/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checks.BaseJavaTermCheck;
import com.liferay.source.formatter.parser.JavaTerm;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaElseStatementCheck
extends BaseJavaTermCheck {
    private final Pattern _elseStatementPattern = Pattern.compile("\t+else \\{\n\t(\t+)(return[ ;\n].*?)(.\\}.)", 32);

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) {
        String javaTermContent = javaTerm.getContent();
        Matcher matcher = this._elseStatementPattern.matcher(javaTermContent);
        while (matcher.find()) {
            String s;
            if (!this._isRedundantElseStatement(javaTermContent, matcher.start()) || !(s = matcher.group(3)).matches("\t}\n")) continue;
            String replacement = StringBundler.concat("\n\n", matcher.group(1), StringUtil.replace(StringUtil.trimTrailing(matcher.group(2)), "\n\t", "\n"), "\n");
            return StringUtil.replaceFirst(javaTermContent, matcher.group(), replacement, matcher.start());
        }
        return javaTermContent;
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_CONSTRUCTOR, JAVA_METHOD};
    }

    private boolean _isRedundantElseStatement(String content, int x) {
        int y = x;
        block0: while (true) {
            String s;
            if (ToolsUtil.isInsideQuotes(content, y = content.lastIndexOf("{", y - 1)) || this.getLevel(s = content.substring(y, x), "{", "}") != 0) {
                continue;
            }
            int z = s.lastIndexOf("\treturn");
            if (z == -1) {
                return false;
            }
            if (this.getLevel(s = s.substring(z), "{", "}") != -1) {
                return false;
            }
            int i = this.getLineNumber(content, y);
            while (true) {
                String line;
                if ((line = StringUtil.trim(this.getLine(content, i))).startsWith("if (")) {
                    return true;
                }
                if (line.startsWith("else if (")) {
                    x = y - 1;
                    continue block0;
                }
                --i;
            }
            break;
        }
    }
}

