/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.util.SourceUtil;
import com.liferay.source.formatter.util.DebugUtil;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;

public abstract class BaseCheck
extends AbstractCheck {
    private boolean _enabled = true;
    private String[] _runOutsidePortalExcludes = new String[0];
    private boolean _showDebugInformation;

    public int[] getAcceptableTokens() {
        return this.getDefaultTokens();
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void setEnabled(boolean enabled) {
        this._enabled = enabled;
    }

    public void setRunOutsidePortalExcludes(String runOutsidePortalExcludes) {
        this._runOutsidePortalExcludes = ArrayUtil.append(this._runOutsidePortalExcludes, StringUtil.split(runOutsidePortalExcludes));
    }

    public void setShowDebugInformation(boolean showDebugInformation) {
        this._showDebugInformation = showDebugInformation;
    }

    public void visitToken(DetailAST detailAST) {
        if (!this._enabled) {
            return;
        }
        if (!this._showDebugInformation) {
            this.doVisitToken(detailAST);
            return;
        }
        long startTime = System.currentTimeMillis();
        this.doVisitToken(detailAST);
        long endTime = System.currentTimeMillis();
        Class<?> clazz = ((Object)((Object)this)).getClass();
        DebugUtil.increaseProcessingTime(clazz.getSimpleName(), endTime - startTime);
    }

    protected abstract void doVisitToken(DetailAST var1);

    protected boolean isRunOutsidePortalExclude() {
        if (ArrayUtil.isEmpty(this._runOutsidePortalExcludes)) {
            return false;
        }
        FileContents fileContents = this.getFileContents();
        String fileName = StringUtil.replace(fileContents.getFileName(), '\\', '/');
        String absolutePath = SourceUtil.getAbsolutePath(fileName);
        for (String exclude : this._runOutsidePortalExcludes) {
            if (Validator.isNull(exclude)) continue;
            if (exclude.startsWith("**")) {
                exclude = exclude.substring(2);
            }
            if (!(exclude.endsWith("**") ? absolutePath.contains(exclude = exclude.substring(0, exclude.length() - 2)) : absolutePath.endsWith(exclude))) continue;
            return true;
        }
        return false;
    }
}

