/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.List;

public class FrameworkBundleCheck
extends BaseCheck {
    private static final String _MSG_USE_BUNDLE_GET_HEADERS = "bundle.get.headers.use";

    public int[] getDefaultTokens() {
        return new int[]{14};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        DetailAST parentAST = detailAST.getParent();
        if (parentAST != null) {
            return;
        }
        List<String> importNames = DetailASTUtil.getImportNames(detailAST);
        if (!importNames.contains("org.osgi.framework.Bundle")) {
            return;
        }
        List<DetailAST> detailASTList = DetailASTUtil.getAllChildTokens(detailAST, true, 8, 9);
        for (DetailAST curDetailAST : detailASTList) {
            this._checkGetHeadersMethodCall(curDetailAST);
        }
    }

    private void _checkGetHeadersMethodCall(DetailAST detailAST) {
        List<DetailAST> methodCallASTList = DetailASTUtil.getMethodCalls(detailAST, "getHeaders");
        for (DetailAST methodCallAST : methodCallASTList) {
            String variableName;
            String variableTypeName;
            DetailAST elistAST = methodCallAST.findFirstToken(34);
            List<DetailAST> exprASTList = DetailASTUtil.getAllChildTokens(elistAST, false, 28);
            if (!exprASTList.isEmpty() || !(variableTypeName = DetailASTUtil.getVariableTypeName(methodCallAST, variableName = DetailASTUtil.getVariableName(methodCallAST), false)).equals("Bundle")) continue;
            this.log(methodCallAST, _MSG_USE_BUNDLE_GET_HEADERS, new Object[0]);
        }
    }
}

