/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class LineBreakBeforeGenericStartCheck
extends BaseCheck {
    private static final String _MSG_INCORRECT_LINE_BREAK = "line.break.incorrect";

    public int[] getDefaultTokens() {
        return new int[]{172};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        if (this._isAtLineStart(detailAST)) {
            return;
        }
        DetailAST nextSiblingAST = detailAST.getNextSibling();
        while (true) {
            if (nextSiblingAST == null) {
                return;
            }
            if (nextSiblingAST.getType() == 173) break;
            nextSiblingAST = nextSiblingAST.getNextSibling();
        }
        if (detailAST.getLineNo() == nextSiblingAST.getLineNo()) {
            return;
        }
        String line = this.getLine(detailAST.getLineNo() - 1);
        String s = StringUtil.trim(line.substring(0, detailAST.getColumnNo()));
        this.log(detailAST, _MSG_INCORRECT_LINE_BREAK, new Object[]{s});
    }

    private boolean _isAtLineStart(DetailAST detailAST) {
        String line = this.getLine(DetailASTUtil.getStartLine(detailAST) - 1);
        for (int i = 0; i < detailAST.getColumnNo(); ++i) {
            char c = line.charAt(i);
            if (c == ' ' || c == '\t') continue;
            return false;
        }
        return true;
    }
}

