/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.checks.javadoc.AbstractJavadocCheck;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class SingleLineJavadocCheck
extends AbstractJavadocCheck {
    public static final String MSG_KEY = "singleline.javadoc";
    private List<String> ignoredTags = new ArrayList<String>();
    private boolean ignoreInlineTags = true;

    public void setIgnoredTags(String ... tags) {
        this.ignoredTags = Arrays.stream(tags).collect(Collectors.toList());
    }

    public void setIgnoreInlineTags(boolean ignoreInlineTags) {
        this.ignoreInlineTags = ignoreInlineTags;
    }

    @Override
    public int[] getDefaultJavadocTokens() {
        return new int[]{10000};
    }

    @Override
    public int[] getRequiredJavadocTokens() {
        return this.getAcceptableJavadocTokens();
    }

    @Override
    public void visitJavadocToken(DetailNode ast) {
        if (SingleLineJavadocCheck.isSingleLineJavadoc(this.getBlockCommentAst()) && (this.hasJavadocTags(ast) || !this.ignoreInlineTags && this.hasJavadocInlineTags(ast))) {
            this.log(ast.getLineNumber(), MSG_KEY, new Object[0]);
        }
    }

    private static boolean isSingleLineJavadoc(DetailAST blockCommentStart) {
        DetailAST blockCommentEnd = blockCommentStart.getLastChild();
        return blockCommentStart.getLineNo() == blockCommentEnd.getLineNo();
    }

    private boolean hasJavadocTags(DetailNode javadocRoot) {
        DetailNode javadocTagSection = JavadocUtil.findFirstToken(javadocRoot, 10071);
        return javadocTagSection != null && !this.isTagIgnored(javadocTagSection);
    }

    private boolean hasJavadocInlineTags(DetailNode javadocRoot) {
        DetailNode javadocTagSection = JavadocUtil.findFirstToken(javadocRoot, 10072);
        boolean foundTag = false;
        while (javadocTagSection != null) {
            if (!this.isTagIgnored(javadocTagSection)) {
                foundTag = true;
                break;
            }
            javadocTagSection = JavadocUtil.getNextSibling(javadocTagSection, 10072);
        }
        return foundTag;
    }

    private boolean isTagIgnored(DetailNode javadocTagSection) {
        return this.ignoredTags.contains(JavadocUtil.getTagName(javadocTagSection));
    }
}

