/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.BaseSourceCheck;
import com.liferay.source.formatter.checks.FileCheck;
import com.liferay.source.formatter.checks.comparator.ElementComparator;
import java.util.Iterator;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.Text;

public abstract class BaseFileCheck
extends BaseSourceCheck
implements FileCheck {
    @Override
    public String process(String fileName, String absolutePath, String content) throws Exception {
        this.clearSourceFormatterMessages(fileName);
        return this.doProcess(fileName, absolutePath, content);
    }

    protected void checkElementOrder(String fileName, Element rootElement, String elementName, String parentElementName, ElementComparator elementComparator) {
        if (rootElement == null) {
            return;
        }
        Node previousNode = null;
        Iterator iterator = rootElement.nodeIterator();
        while (iterator.hasNext()) {
            Text text;
            Node curNode = (Node)iterator.next();
            if (curNode instanceof Text && !StringUtil.startsWith(StringUtil.trim((text = (Text)curNode).asXML()), '#')) continue;
            if (previousNode == null) {
                previousNode = curNode;
                continue;
            }
            if (curNode instanceof Element && previousNode instanceof Element) {
                Element curElement = (Element)curNode;
                Element previousElement = (Element)previousNode;
                String curElementName = curElement.getName();
                String previousElementName = previousElement.getName();
                if (curElementName.equals(elementName) && previousElementName.equals(elementName) && elementComparator.compare(previousElement, curElement) > 0) {
                    StringBundler sb = new StringBundler(9);
                    sb.append("Incorrect order '");
                    if (Validator.isNotNull(parentElementName)) {
                        sb.append(parentElementName);
                        sb.append("#");
                    }
                    sb.append(elementName);
                    sb.append("': '");
                    sb.append(elementComparator.getElementName(previousElement));
                    sb.append("' should come after '");
                    sb.append(elementComparator.getElementName(curElement));
                    sb.append("'");
                    this.addMessage(fileName, sb.toString());
                }
            }
            previousNode = curNode;
        }
    }

    protected abstract String doProcess(String var1, String var2, String var3) throws Exception;

    protected int getLineLength(String line) {
        int lineLength = 0;
        int tabLength = 4;
        for (char c : line.toCharArray()) {
            if (c == '\t') {
                for (int i = 0; i < tabLength; ++i) {
                    ++lineLength;
                }
                tabLength = 4;
                continue;
            }
            ++lineLength;
            if (--tabLength > 0) continue;
            tabLength = 4;
        }
        return lineLength;
    }
}

