/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.source.formatter.checks.IfStatementCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FTLIfStatementCheck
extends IfStatementCheck {
    private static final Pattern _ifStatementPattern = Pattern.compile("[\t\n]<#(else)?if ([^?\n]*)>\n");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        Matcher matcher = _ifStatementPattern.matcher(content);
        while (matcher.find()) {
            String ifClause = "if (" + matcher.group(2) + ") {";
            this.checkIfClauseParentheses(ifClause, fileName, this.getLineNumber(content, matcher.start(2)));
        }
        return content;
    }
}

