/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FTLStringRelationalOperatorCheck
extends BaseFileCheck {
    private static final Pattern _stringRelationalOperationPattern = Pattern.compile("(\\W)([\\w.]+) ([!=]=) \"(\\w*)\"(.)");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        return this._formatStringRelationalOperations(content);
    }

    private String _formatStringRelationalOperations(String content) {
        Matcher matcher = _stringRelationalOperationPattern.matcher(content);
        if (!matcher.find()) {
            return content;
        }
        String match = matcher.group();
        String firstChar = matcher.group(1);
        String lastChar = matcher.group(5);
        if (!firstChar.equals("(") || !lastChar.equals(")")) {
            match = content.substring(matcher.end(1), matcher.start(5));
        }
        String operator = matcher.group(3);
        String quotedString = matcher.group(4);
        String variableName = matcher.group(2);
        String replacement = null;
        if (Validator.isNull(quotedString)) {
            replacement = operator.equals("==") ? "validator.isNull(" + variableName + ")" : "validator.isNotNull(" + variableName + ")";
        } else {
            StringBundler sb = new StringBundler(6);
            if (operator.equals("!=")) {
                sb.append("!");
            }
            sb.append("stringUtil.equals(");
            sb.append(variableName);
            sb.append(", \"");
            sb.append(quotedString);
            sb.append("\")");
            replacement = sb.toString();
        }
        return StringUtil.replaceFirst(content, match, replacement, matcher.start());
    }
}

