/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checks.BaseJavaTermCheck;
import com.liferay.source.formatter.checks.util.JavaSourceUtil;
import com.liferay.source.formatter.parser.JavaTerm;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaLogParametersCheck
extends BaseJavaTermCheck {
    private static final Pattern _logPattern = Pattern.compile("_log\\.(debug|error|fatal|info|trace|warn)\\((.+?)\\);\n", 32);

    @Override
    public boolean isPortalCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) {
        String content = javaTerm.getContent();
        Matcher matcher = _logPattern.matcher(content);
        while (matcher.find()) {
            String variableTypeName;
            String firstParameter;
            List<String> parametersList;
            if (ToolsUtil.isInsideQuotes(content, matcher.start()) || (parametersList = JavaSourceUtil.getParameterList(matcher.group())).isEmpty() || !Validator.isVariableName(firstParameter = StringUtil.trim(parametersList.get(0))) || (variableTypeName = this.getVariableTypeName(content, fileContent, firstParameter)) == null) continue;
            if (variableTypeName.equals("StringBundler")) {
                return StringUtil.replaceFirst(content, firstParameter, firstParameter + ".toString()", matcher.start(2));
            }
            if (parametersList.size() != 1 || !variableTypeName.endsWith("Exception")) continue;
            return StringUtil.replaceFirst(content, firstParameter, StringBundler.concat(firstParameter, ", ", firstParameter), matcher.start(2));
        }
        return content;
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_CONSTRUCTOR, JAVA_METHOD};
    }
}

