/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.SourceUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class XMLCustomSQLStylingCheck
extends BaseFileCheck {
    private static final String _CUSTOM_FINDER_SCALABILITY_EXCLUDES = "custom.finder.scalability.excludes";
    private static final String[] _SQL_KEYWORDS = new String[]{"ALL", "AND", "AS", "ASC", "BITAND", "BY", "COUNT", "CROSS", "DELETE", "DESC", "DISTINCT", "EXISTS", "FROM", "GROUP", "HAVING", "IN", "INNER", "IS", "JOIN", "LEFT", "LIKE", "LOWER", "MAX", "MOD", "NOT", "NULL", "ON", "OR", "ORDER", "OUTER", "SELECT", "SET", "SUM", "UNION", "UPDATE", "WHERE"};
    private static final Pattern _incorrectAndOrpattern = Pattern.compile("(\n\t*)(AND|OR|\\[\\$AND_OR_CONNECTOR\\$\\])( |\n)");
    private static final Pattern _incorrectLineBreakAfterCommaPattern = Pattern.compile(".(?<! (ASC|DESC)),\n");
    private static final Pattern _missingCountValuePattern = Pattern.compile("SELECT\\s+COUNT\\([^()\n]+(\\))\\s+FROM");
    private static final Pattern _missingLineBreakAfterKeywordPattern = Pattern.compile("\n\\s*(.*\\s(BY|FROM|HAVING|JOIN|ON|SELECT|WHERE)) ");
    private static final Pattern _missingLineBreakAfterOpenParenthesisPattern = Pattern.compile("(\t+)\\(.+\n");
    private static final Pattern _missingLineBreakBeforeOpenParenthesisPattern = Pattern.compile("\n(\t+).*[^\t\n]\\(\n");
    private static final Pattern _missingParenthesesPattern1 = Pattern.compile("\t([^\t]*(\\S))\\s+(AND|OR|\\[\\$AND_OR_CONNECTOR\\$\\])\\s*\n");
    private static final Pattern _missingParenthesesPattern2 = Pattern.compile("\\s(AND|OR|\\[\\$AND_OR_CONNECTOR\\$\\])\\s+[^\\(\\[<\\s]");
    private static final Pattern _multiLineSinglePredicatePattern = Pattern.compile("\t\\(\n(.*)\n\t*\\)");
    private static final Pattern _redundantParenthesesForSingleLineClausePattern = Pattern.compile("\\s(ON|WHERE)\\s+\\((.*)\\)\n(.*)\n");
    private static final Pattern _singleLineClauseWitMultiplePredicatesPattern = Pattern.compile("\n(\t*)((.*\\)) (AND|OR|\\[\\$AND_OR_CONNECTOR\\$\\]) (\\(.*))");
    private static final Pattern _unionPattern = Pattern.compile("(\\S)(\\s+)UNION( ALL)?\\s+(\\S)");
    private static final Pattern _whereNotInSQLPattern = Pattern.compile("WHERE\\s.*\\sNOT IN", 32);

    @Override
    public boolean isPortalCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws DocumentException {
        if (!fileName.contains("/custom-sql/")) {
            return content;
        }
        this._checkIncorrectLineBreakAfterComma(fileName, content);
        this._checkMissingLineBreakAfterKeyword(fileName, content);
        this._checkMissingParentheses(fileName, content);
        this._checkMultiLineClause(fileName, content);
        this._checkScalability(fileName, absolutePath, content);
        this._checkUnionStatement(fileName, content);
        content = this._fixIncorrectAndOr(content);
        content = this._fixLowerCaseKeywords(content);
        content = this._fixMissingCountValue(content);
        content = this._fixMissingLineBreakAfterOpenParenthesis(content);
        content = this._fixMissingLineBreakBeforeOpenParenthesis(content);
        content = this._fixRedundantParenthesesForSingleLineClause(content);
        content = this._fixSinglePredicateClause(content);
        content = this._formatSingleLineClauseWithMultiplePredicates(fileName, content);
        return content;
    }

    private String _addTabs(String content, int start, int end) {
        for (int i = start; i <= end; ++i) {
            int lineStartPos = this.getLineStartPos(content, i);
            content = content.substring(0, lineStartPos) + "\t" + content.substring(lineStartPos);
        }
        return content;
    }

    private void _checkIncorrectLineBreakAfterComma(String fileName, String content) {
        Matcher matcher = _incorrectLineBreakAfterCommaPattern.matcher(content);
        while (matcher.find()) {
            this.addMessage(fileName, "Incorrect line break after ','", this.getLineNumber(content, matcher.start()));
        }
    }

    private void _checkMissingLineBreakAfterKeyword(String fileName, String content) {
        Matcher matcher = _missingLineBreakAfterKeywordPattern.matcher(content);
        while (matcher.find()) {
            this.addMessage(fileName, "There should be a line break after '" + StringUtil.trim(matcher.group(1)), this.getLineNumber(content, matcher.end()));
        }
    }

    private void _checkMissingParentheses(String fileName, String content) {
        Matcher matcher = _missingParenthesesPattern1.matcher(content);
        while (matcher.find()) {
            String s;
            String charBeforeOperator = matcher.group(2);
            if (charBeforeOperator.equals(")") ? (s = matcher.group(1)).equals(")") || s.startsWith("(") && this.getLevel(s) == 0 : charBeforeOperator.equals("]") && (s = matcher.group(1)).startsWith("[") && this.getLevel(s, "[", "]") == 0) continue;
            this.addMessage(fileName, "Missing parentheses", this.getLineNumber(content, matcher.start()));
        }
        matcher = _missingParenthesesPattern2.matcher(content);
        while (matcher.find()) {
            String nextLine = this.getLine(content, this.getLineNumber(content, matcher.end()));
            if (nextLine.endsWith(" IN") || nextLine.endsWith("EXISTS") || nextLine.matches(".*\\s+BETWEEN\\s+\\?\\s+AND\\s+\\?.*")) continue;
            this.addMessage(fileName, "Missing parentheses", this.getLineNumber(content, matcher.end()));
        }
    }

    private void _checkMultiLineClause(String fileName, String content) {
        int startPos = -1;
        while ((startPos = content.indexOf("\t(\n", startPos + 1)) != -1) {
            int startLineStartPos;
            int startLineTabCount;
            int endLineTabCount;
            int endPos = this._getCloseParenthesisPos(content, startPos);
            int endLineNumber = this.getLineNumber(content, endPos);
            int endLineStartPos = content.lastIndexOf("\n", endPos);
            char c = content.charAt(endPos - 1);
            if (c != '\t') {
                this.addMessage(fileName, "There should be a line break after '" + StringUtil.trim(content.substring(endLineStartPos, endPos)), endLineNumber);
                continue;
            }
            String afterCloseParenthesis = StringUtil.trim(content.substring(endPos + 1));
            String beforeOpenParenthesis = StringUtil.trim(content.substring(0, startPos));
            if (!(!beforeOpenParenthesis.endsWith(" ON") && !beforeOpenParenthesis.endsWith("\tWHERE") || afterCloseParenthesis.startsWith("AND") || afterCloseParenthesis.startsWith("OR") || afterCloseParenthesis.startsWith("["))) {
                this.addMessage(fileName, "redundant parentheses", this.getLineNumber(content, startPos));
            }
            if ((endLineTabCount = endPos - endLineStartPos - 1) == (startLineTabCount = startPos - (startLineStartPos = content.lastIndexOf("\n", startPos)))) continue;
            this.addMessage(fileName, StringBundler.concat("Line starts with '", String.valueOf(endLineTabCount), "' tabs, but '", String.valueOf(startLineTabCount), "' tabs are expected"), endLineNumber);
        }
        return;
    }

    private void _checkScalability(String fileName, String absolutePath, String content) throws DocumentException {
        Document document = SourceUtil.readXML(content);
        Element rootElement = document.getRootElement();
        for (Element sqlElement : rootElement.elements("sql")) {
            String sql = sqlElement.getText();
            Matcher matcher = _whereNotInSQLPattern.matcher(sql);
            while (matcher.find()) {
                int x;
                int y;
                String id = sqlElement.attributeValue("id");
                String entityName = id.substring((y = id.lastIndexOf(46, (x = id.lastIndexOf(46)) - 1)) + 1, x);
                if (this.isExcludedPath(_CUSTOM_FINDER_SCALABILITY_EXCLUDES, absolutePath, entityName)) continue;
                this.addMessage(fileName, "Avoid using WHERE ... NOT IN: " + id + ", see LPS-51315");
            }
        }
    }

    private void _checkUnionStatement(String fileName, String content) {
        Matcher matcher = _unionPattern.matcher(content);
        while (matcher.find()) {
            int openParenthesisPos;
            String s;
            String beforeUnionChar = matcher.group(1);
            if (beforeUnionChar.equals(")") && (s = StringUtil.trim(content.substring((openParenthesisPos = this._getOpenParenthesisPos(content, matcher.start(1))) + 1, matcher.start()))).startsWith("SELECT")) {
                this.addMessage(fileName, "Do not use parentheses before UNION", this.getLineNumber(content, matcher.start()));
                continue;
            }
            String afterUnionChar = matcher.group(4);
            if (!afterUnionChar.equals("(")) continue;
            this.addMessage(fileName, "Do not use parentheses after UNION", this.getLineNumber(content, matcher.start(3)));
        }
    }

    private String _fixIncorrectAndOr(String content) {
        Matcher matcher = _incorrectAndOrpattern.matcher(content);
        if (matcher.find()) {
            String whitespace = matcher.group(3);
            if (whitespace.equals(" ")) {
                return StringUtil.replaceFirst(content, matcher.group(), " " + matcher.group(2) + matcher.group(1), matcher.start() - 1);
            }
            return StringUtil.replaceFirst(content, matcher.group(1), " ", matcher.start() - 1);
        }
        return content;
    }

    private String _fixLowerCaseKeywords(String content) {
        for (String keyword : _SQL_KEYWORDS) {
            Pattern pattern = Pattern.compile("[^\\w.$'\"](" + keyword + ")[^\\w.$'\"]", 2);
            Matcher matcher = pattern.matcher(content);
            while (matcher.find()) {
                int level = this.getLevel(content.substring(0, matcher.start()), "<![CDATA[", "]]>");
                if (level == 0) continue;
                content = StringUtil.replaceFirst(content, matcher.group(1), keyword, matcher.start());
            }
        }
        return content;
    }

    private String _fixMissingCountValue(String content) {
        Matcher matcher = _missingCountValuePattern.matcher(content);
        if (matcher.find()) {
            return StringUtil.insert(content, " AS COUNT_VALUE", matcher.end(1));
        }
        return content;
    }

    private String _fixMissingLineBreakAfterOpenParenthesis(String content) {
        Matcher matcher = _missingLineBreakAfterOpenParenthesisPattern.matcher(content);
        while (matcher.find()) {
            if (this.getLevel(matcher.group()) == 0) continue;
            int startPos = matcher.end(1);
            int startLineNumber = this.getLineNumber(content, startPos);
            int endPos = this._getCloseParenthesisPos(content, startPos);
            int endLineNumber = this.getLineNumber(content, endPos);
            content = this._addTabs(content, startLineNumber + 1, endLineNumber - 1);
            return StringUtil.replaceFirst(content, "\t(", "\t(\n\t" + matcher.group(1), matcher.start());
        }
        return content;
    }

    private String _fixMissingLineBreakBeforeOpenParenthesis(String content) {
        Matcher matcher = _missingLineBreakBeforeOpenParenthesisPattern.matcher(content);
        if (!matcher.find()) {
            return content;
        }
        int startPos = matcher.end() - 2;
        int startLineNumber = this.getLineNumber(content, startPos);
        int endPos = this._getCloseParenthesisPos(content, startPos);
        int endLineNumber = this.getLineNumber(content, endPos);
        content = this._addTabs(content, startLineNumber + 1, endLineNumber);
        return StringUtil.replaceFirst(content, "(\n", "\n\t" + matcher.group(1) + "(\n", matcher.start());
    }

    private String _fixRedundantParenthesesForSingleLineClause(String content) {
        Matcher matcher = _redundantParenthesesForSingleLineClausePattern.matcher(content);
        while (matcher.find()) {
            String trimmedNextLine = StringUtil.trim(matcher.group(3));
            if (trimmedNextLine.startsWith("AND") || trimmedNextLine.startsWith("OR") || trimmedNextLine.startsWith("[$AND_OR_CONNECTOR$]")) continue;
            return StringUtil.replaceFirst(content, "(" + matcher.group(2) + ")", matcher.group(2), matcher.start());
        }
        return content;
    }

    private String _fixSinglePredicateClause(String content) {
        Matcher matcher = _multiLineSinglePredicatePattern.matcher(content);
        while (matcher.find()) {
            String line = StringUtil.trim(matcher.group(1));
            if (line.startsWith("[") && line.endsWith("]")) continue;
            return StringUtil.replace(content, matcher.group(), "\t(" + line + ")");
        }
        return content;
    }

    private String _formatSingleLineClauseWithMultiplePredicates(String fileName, String content) {
        Matcher matcher = _singleLineClauseWitMultiplePredicatesPattern.matcher(content);
        while (matcher.find()) {
            String afterOperator = matcher.group(5);
            String beforeOperator = matcher.group(3);
            String indent = matcher.group(1);
            String match = matcher.group(2);
            String operator = matcher.group(4);
            StringBundler sb = new StringBundler(11);
            if (beforeOperator.equals(")")) {
                sb.append(") ");
                sb.append(operator);
                sb.append("\n");
                sb.append(indent);
                sb.append(afterOperator);
                return StringUtil.replaceFirst(content, match, sb.toString(), matcher.start());
            }
            int lineNumber = this.getLineNumber(content, matcher.start(3));
            if (this.getLevel(match) != 0 || !match.startsWith("(")) {
                this.addMessage(fileName, "One SQL predicate per line", lineNumber);
                continue;
            }
            int beforeOperatorlevel = this.getLevel(beforeOperator);
            if (beforeOperatorlevel < 0 || beforeOperatorlevel > 1) {
                this.addMessage(fileName, "One SQL predicate per line", lineNumber);
                continue;
            }
            if (beforeOperatorlevel == 0) {
                sb.append(beforeOperator);
                sb.append(" ");
                sb.append(operator);
                sb.append("\n");
                sb.append(indent);
                sb.append(afterOperator);
                return StringUtil.replaceFirst(content, match, sb.toString(), matcher.start());
            }
            sb.append("(\n\t");
            sb.append(indent);
            sb.append(beforeOperator.substring(1));
            sb.append(" ");
            sb.append(operator);
            sb.append("\n\t");
            sb.append(indent);
            int pos = afterOperator.lastIndexOf(")");
            sb.append(afterOperator.substring(0, pos));
            sb.append("\n");
            sb.append(indent);
            sb.append(afterOperator.substring(pos));
            return StringUtil.replaceFirst(content, match, sb.toString(), matcher.start());
        }
        return content;
    }

    private int _getCloseParenthesisPos(String content, int startPos) {
        int endPos = startPos;
        while (this.getLevel(content.substring(startPos, (endPos = content.indexOf(")", endPos + 1)) + 1)) != 0) {
        }
        return endPos;
    }

    private int _getOpenParenthesisPos(String content, int endPos) {
        int startPos = endPos;
        while (this.getLevel(content.substring(startPos = content.lastIndexOf("(", startPos - 1), endPos + 1)) != 0) {
        }
        return startPos;
    }
}

