/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.util.JavaSourceUtil;
import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.FileText;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ChainingCheck
extends BaseCheck {
    private static final String _MSG_ALLOWED_CHAINING = "chaining.allowed";
    private static final String _MSG_AVOID_CHAINING = "chaining.avoid";
    private static final String _MSG_AVOID_TOO_MANY_CONCAT = "concat.avoid.too.many";
    private static final String _MSG_INCORRECT_STYLING = "styling.incorrect";
    private String[] _allowedClassNames = new String[0];
    private String[] _allowedMethodNames = new String[0];
    private String[] _allowedVariableTypeNames = new String[0];

    public int[] getDefaultTokens() {
        return new int[]{8, 9};
    }

    public void setAllowedClassNames(String allowedClassNames) {
        this._allowedClassNames = ArrayUtil.append(this._allowedClassNames, StringUtil.split(allowedClassNames));
    }

    public void setAllowedMethodNames(String allowedMethodNames) {
        this._allowedMethodNames = ArrayUtil.append(this._allowedMethodNames, StringUtil.split(allowedMethodNames));
    }

    public void setAllowedVariableTypeNames(String allowedVariableTypeNames) {
        this._allowedVariableTypeNames = ArrayUtil.append(this._allowedVariableTypeNames, StringUtil.split(allowedVariableTypeNames));
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        List<DetailAST> methodCallDetailASTList = DetailASTUtil.getAllChildTokens(detailAST, true, 27);
        for (DetailAST methodCallDetailAST : methodCallDetailASTList) {
            List<String> chain;
            int chainSize;
            List<DetailAST> childMethodCallDetailASTList;
            DetailAST dotDetailAST = methodCallDetailAST.findFirstToken(59);
            if (dotDetailAST != null && !(childMethodCallDetailASTList = DetailASTUtil.getAllChildTokens(dotDetailAST, false, 27)).isEmpty()) continue;
            this._checkAllowedChaining(methodCallDetailAST);
            if (this._isInsideAnonymousClassVariableDefinition(methodCallDetailAST) || (chainSize = (chain = this._getChain(methodCallDetailAST)).size()) == 1) continue;
            if (chainSize == 2) {
                FileContents fileContents;
                String fileName;
                if (dotDetailAST == null) continue;
                this._checkMethodName(chain, "getClass", methodCallDetailAST, detailAST);
                String name1 = chain.get(0);
                if ((name1.equals("getParamValue") || name1.equals("getValue")) && DetailASTUtil.hasParentWithTokenType(detailAST, 154)) continue;
                String name2 = chain.get(1);
                if (name1.equals("concat") || name2.equals("concat") || (fileName = StringUtil.replace((fileContents = this.getFileContents()).getFileName(), '\\', '/')).contains("/test/") || fileName.contains("/testIntegration/")) continue;
            }
            if (this._isAllowedChainingMethodCall(detailAST, methodCallDetailAST, chain)) {
                if (chainSize <= 1) continue;
                this._checkStyling(detailAST, methodCallDetailAST);
                continue;
            }
            int concatsCount = Collections.frequency(chain, "concat");
            if (concatsCount > 2) {
                this.log(methodCallDetailAST, _MSG_AVOID_TOO_MANY_CONCAT, new Object[0]);
                continue;
            }
            if (chainSize == 3 && concatsCount == 2) continue;
            this.log(methodCallDetailAST, _MSG_AVOID_CHAINING, new Object[]{DetailASTUtil.getMethodName(methodCallDetailAST)});
        }
    }

    private void _checkAllowedChaining(DetailAST methodCallDetailAST) {
        DetailAST parentDetailAST = methodCallDetailAST.getParent();
        while (parentDetailAST.getType() == 59 || parentDetailAST.getType() == 27) {
            parentDetailAST = parentDetailAST.getParent();
        }
        if (parentDetailAST.getType() != 28) {
            return;
        }
        if ((parentDetailAST = parentDetailAST.getParent()).getType() != 80) {
            return;
        }
        if ((parentDetailAST = parentDetailAST.getParent()).getType() != 10) {
            return;
        }
        String classOrVariableName = this._getClassOrVariableName(methodCallDetailAST);
        if (!(Objects.equals(classOrVariableName, "Optional") || Objects.equals(classOrVariableName, "Stream") || Objects.equals(classOrVariableName, "Try"))) {
            return;
        }
        DetailAST variableNameDetailAST = parentDetailAST.findFirstToken(58);
        String variableName = variableNameDetailAST.getText();
        String variableTypeName = DetailASTUtil.getVariableTypeName(methodCallDetailAST, variableName, false);
        if (!classOrVariableName.equals(variableTypeName)) {
            return;
        }
        List<DetailAST> identDetailASTList = this._getIdentDetailASTList(parentDetailAST.getParent(), variableName);
        if (identDetailASTList.size() == 2 && Objects.equals(this._findFirstParent(identDetailASTList.get(0), 34, 83), this._findFirstParent(identDetailASTList.get(1), 34, 83))) {
            this.log(methodCallDetailAST, _MSG_ALLOWED_CHAINING, new Object[]{StringBundler.concat(classOrVariableName, ".", DetailASTUtil.getMethodName(methodCallDetailAST))});
        }
    }

    private void _checkMethodName(List<String> chainedMethodNames, String methodName, DetailAST methodCallDetailAST, DetailAST detailAST) {
        String firstMethodName = chainedMethodNames.get(0);
        if (firstMethodName.equals(methodName) && !this._isInsideConstructorThisCall(methodCallDetailAST, detailAST) && !DetailASTUtil.hasParentWithTokenType(methodCallDetailAST, 42)) {
            this.log(methodCallDetailAST, _MSG_AVOID_CHAINING, new Object[]{methodName});
        }
    }

    private void _checkStyling(DetailAST detailAST, DetailAST methodCallDetailAST) {
        if (this._isInsideConstructorThisCall(methodCallDetailAST, detailAST) || DetailASTUtil.hasParentWithTokenType(methodCallDetailAST, 42)) {
            return;
        }
        for (int i = DetailASTUtil.getStartLineNumber(methodCallDetailAST) + 1; i <= DetailASTUtil.getEndLineNumber(methodCallDetailAST); ++i) {
            String line = StringUtil.trim(this.getLine(i - 1));
            if (!line.startsWith(").")) continue;
            return;
        }
        this.log(methodCallDetailAST, _MSG_INCORRECT_STYLING, new Object[]{DetailASTUtil.getMethodName(methodCallDetailAST)});
    }

    private DetailAST _findFirstParent(DetailAST detailAST, int ... types) {
        DetailAST parentDetailAST = detailAST.getParent();
        while (parentDetailAST != null) {
            if (ArrayUtil.contains(types, parentDetailAST.getType())) {
                return parentDetailAST;
            }
            parentDetailAST = parentDetailAST.getParent();
        }
        return null;
    }

    private List<String> _getChain(DetailAST methodCallDetailAST) {
        ArrayList<String> chain = new ArrayList<String>();
        chain.add(DetailASTUtil.getMethodName(methodCallDetailAST));
        DetailAST parentDetailAST;
        while ((parentDetailAST = methodCallDetailAST.getParent()).getType() == 59) {
            DetailAST grandParentDetailAST = parentDetailAST.getParent();
            if (grandParentDetailAST.getType() != 27) {
                DetailAST siblingDetailAST = methodCallDetailAST.getNextSibling();
                if (siblingDetailAST.getType() == 58) {
                    chain.add(siblingDetailAST.getText());
                }
                return chain;
            }
            methodCallDetailAST = grandParentDetailAST;
            chain.add(DetailASTUtil.getMethodName(methodCallDetailAST));
        }
        return chain;
    }

    private String _getClassOrVariableName(DetailAST methodCallDetailAST) {
        DetailAST dotDetailAST = methodCallDetailAST.findFirstToken(59);
        if (dotDetailAST == null) {
            return null;
        }
        DetailAST nameDetailAST = null;
        DetailAST firstChildDetailAST = dotDetailAST.getFirstChild();
        nameDetailAST = firstChildDetailAST.getType() == 136 ? firstChildDetailAST.findFirstToken(58) : dotDetailAST.findFirstToken(58);
        if (nameDetailAST != null) {
            return nameDetailAST.getText();
        }
        return null;
    }

    private List<DetailAST> _getIdentDetailASTList(DetailAST detailAST, String name) {
        ArrayList<DetailAST> identDetailASTList = new ArrayList<DetailAST>();
        for (DetailAST identDetailAST : DetailASTUtil.getAllChildTokens(detailAST, true, 58)) {
            if (!name.equals(identDetailAST.getText())) continue;
            identDetailASTList.add(identDetailAST);
        }
        return identDetailASTList;
    }

    private DetailAST _getOuterMethodCallDetailAST(DetailAST detailAST) {
        DetailAST parentDetailAST;
        while (true) {
            if (detailAST.getType() != 59 && detailAST.getType() != 27) {
                return null;
            }
            parentDetailAST = detailAST.getParent();
            if (detailAST.getType() == 27 && parentDetailAST.getType() != 59) break;
            detailAST = parentDetailAST;
        }
        while (true) {
            if ((parentDetailAST = detailAST.getParent()) == null) {
                return null;
            }
            if (parentDetailAST.getType() == 27) break;
            detailAST = parentDetailAST;
        }
        detailAST = parentDetailAST;
        while (detailAST.getType() == 59 || detailAST.getType() == 27) {
            DetailAST childDetailAST = detailAST.getFirstChild();
            if (detailAST.getType() == 59 && childDetailAST.getType() != 27) {
                return detailAST.getParent();
            }
            detailAST = childDetailAST;
        }
        return null;
    }

    private boolean _isAllowedChainingMethodCall(DetailAST detailAST, DetailAST methodCallDetailAST, List<String> chainedMethodNames) {
        DetailAST outerMethodCallDetailAST;
        if (this._isInsideConstructorThisCall(methodCallDetailAST, detailAST) || DetailASTUtil.hasParentWithTokenType(methodCallDetailAST, 42)) {
            return true;
        }
        for (String allowedMethodName : this._allowedMethodNames) {
            if (!chainedMethodNames.contains(allowedMethodName)) continue;
            return true;
        }
        DetailAST dotDetailAST = methodCallDetailAST.findFirstToken(59);
        if (dotDetailAST == null) {
            FileContents fileContents = this.getFileContents();
            String fileName = StringUtil.replace(fileContents.getFileName(), '\\', '/');
            String className = JavaSourceUtil.getClassName(fileName);
            for (String allowedClassName : this._allowedClassNames) {
                if (!className.matches(allowedClassName)) continue;
                return true;
            }
            FileText fileText = fileContents.getText();
            String content = (String)fileText.getFullText();
            return content.contains("extends PowerMockito");
        }
        String classOrVariableName = this._getClassOrVariableName(methodCallDetailAST);
        if (classOrVariableName != null) {
            if (this._isLambdaVariable(methodCallDetailAST, classOrVariableName)) {
                return true;
            }
            for (String allowedClassName : this._allowedClassNames) {
                if (!classOrVariableName.matches(allowedClassName)) continue;
                return true;
            }
            String variableTypeName = DetailASTUtil.getVariableTypeName(methodCallDetailAST, classOrVariableName, false);
            if (Validator.isNotNull(variableTypeName)) {
                for (String allowedVariableTypeName : this._allowedVariableTypeNames) {
                    if (!variableTypeName.matches(allowedVariableTypeName)) continue;
                    return true;
                }
            }
        }
        if ((outerMethodCallDetailAST = this._getOuterMethodCallDetailAST(methodCallDetailAST)) != null) {
            return this._isAllowedChainingMethodCall(detailAST, outerMethodCallDetailAST, this._getChain(outerMethodCallDetailAST));
        }
        return false;
    }

    private boolean _isInsideAnonymousClassVariableDefinition(DetailAST detailAST) {
        for (DetailAST parentDetailAST = detailAST.getParent(); parentDetailAST != null; parentDetailAST = parentDetailAST.getParent()) {
            if (parentDetailAST.getType() == 8 || parentDetailAST.getType() == 9) {
                return false;
            }
            if (parentDetailAST.getType() != 10) continue;
            return (parentDetailAST = parentDetailAST.getParent()).getType() == 6;
        }
        return false;
    }

    private boolean _isInsideConstructorThisCall(DetailAST methodCallDetailAST, DetailAST detailAST) {
        if (detailAST.getType() != 8) {
            return false;
        }
        for (DetailAST parentDetailAST = methodCallDetailAST.getParent(); parentDetailAST != null; parentDetailAST = parentDetailAST.getParent()) {
            String parentDetailASTText = parentDetailAST.getText();
            if (parentDetailAST.getType() != 43 || !parentDetailASTText.equals("this")) continue;
            return true;
        }
        return false;
    }

    private boolean _isLambdaVariable(DetailAST methodCallDetailAST, String variableName) {
        for (DetailAST parentDetailAST = methodCallDetailAST.getParent(); parentDetailAST != null; parentDetailAST = parentDetailAST.getParent()) {
            if (parentDetailAST.getType() != 181) {
                continue;
            }
            DetailAST nameDetailAST = parentDetailAST.findFirstToken(58);
            return nameDetailAST != null && variableName.equals(nameDetailAST.getText());
        }
        return false;
    }
}

