/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.BNDSourceUtil;
import com.liferay.source.formatter.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GradleExportedPackageDependenciesCheck
extends BaseFileCheck {
    private static final String[] _SKIP_DIR_NAMES = new String[]{".git", ".gradle", ".idea", ".m2", ".settings", "bin", "build", "classes", "dependencies", "node_modules", "sql", "src", "test", "test-classes", "test-coverage", "test-results", "tmp"};
    private static final Pattern _dependenciesPattern = Pattern.compile("(\n|\\A)(\t*)dependencies \\{\n");
    private static final Pattern _dependencyNamePattern = Pattern.compile(".*, name: \"([^\"]*)\".*");
    private static final Pattern _dependencyVersionPattern = Pattern.compile(".*, version: \"([^\"]*)\".*");
    private Map<String, String> _emptyExportPackageBundleSymbolicMap;

    @Override
    public boolean isPortalCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        if (!absolutePath.contains("/modules/apps/")) {
            return content;
        }
        int x = absolutePath.lastIndexOf("/");
        int y = absolutePath.lastIndexOf("/", x - 1);
        String moduleName = absolutePath.substring(y + 1, x);
        if (!moduleName.contains("test")) {
            for (String dependencies : this._getDependenciesBlocks(content)) {
                content = this._formatDependencies(content, dependencies);
            }
        }
        return content;
    }

    private String _formatDependencies(String content, String dependencies) throws IOException {
        int y;
        int x = dependencies.indexOf("\n");
        if (x == (y = dependencies.lastIndexOf("\n"))) {
            return content;
        }
        dependencies = dependencies.substring(x, y + 1);
        StringBundler sb = new StringBundler();
        for (String line : StringUtil.splitLines(dependencies)) {
            String dependencyName = this._getDependencyName(line);
            if (Objects.isNull(dependencyName) || line.matches(".*\\s+testCompile\\s+.*")) {
                sb.append(line);
                sb.append("\n");
                continue;
            }
            String dependencyVersion = this._getDependencyVersion(line);
            if (!this._isValidBundleSymbolicName(dependencyName, dependencyVersion)) continue;
            sb.append(line);
            sb.append("\n");
        }
        return StringUtil.replace(content, StringUtil.trim(dependencies), StringUtil.trim(sb.toString()));
    }

    private List<String> _getDependenciesBlocks(String content) {
        ArrayList<String> dependenciesBlocks = new ArrayList<String>();
        Matcher matcher = _dependenciesPattern.matcher(content);
        while (matcher.find()) {
            String dependencies;
            int level;
            int y = matcher.start();
            do {
                if ((y = content.indexOf("}", y + 1)) != -1) continue;
                return dependenciesBlocks;
            } while ((level = this.getLevel(dependencies = content.substring(matcher.start(2), y + 1), "{", "}")) != 0);
            if (dependencies.contains("}\n")) continue;
            dependenciesBlocks.add(dependencies);
        }
        return dependenciesBlocks;
    }

    private String _getDependencyName(String dependency) {
        Matcher matcher = _dependencyNamePattern.matcher(dependency);
        if (!matcher.find()) {
            return "";
        }
        return matcher.group(1);
    }

    private String _getDependencyVersion(String dependency) {
        Matcher matcher = _dependencyVersionPattern.matcher(dependency);
        if (!matcher.find()) {
            return "";
        }
        return matcher.group(1);
    }

    private synchronized Map<String, String> _getEmptyExportPackageBundleSymbolicMap() throws IOException {
        if (this._emptyExportPackageBundleSymbolicMap != null) {
            return this._emptyExportPackageBundleSymbolicMap;
        }
        File portalDir = this.getPortalDir();
        if (portalDir == null) {
            this._emptyExportPackageBundleSymbolicMap = Collections.emptyMap();
            return this._emptyExportPackageBundleSymbolicMap;
        }
        final ArrayList files = new ArrayList();
        Files.walkFileTree(portalDir.toPath(), EnumSet.noneOf(FileVisitOption.class), 15, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dirPath, BasicFileAttributes basicFileAttributes) {
                String dirName = String.valueOf(dirPath.getFileName());
                if (ArrayUtil.contains(_SKIP_DIR_NAMES, dirName)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                Path path = dirPath.resolve("bnd.bnd");
                if (Files.exists(path, new LinkOption[0])) {
                    files.add(path.toFile());
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }
        });
        this._emptyExportPackageBundleSymbolicMap = new HashMap<String, String>();
        for (File file : files) {
            String bundleSymbolicName;
            String content = FileUtil.read(file);
            if (content.contains("Export-Package:") || (bundleSymbolicName = BNDSourceUtil.getDefinitionValue(content, "Bundle-SymbolicName")) == null || !bundleSymbolicName.startsWith("com.liferay.")) continue;
            String bundleVersion = BNDSourceUtil.getDefinitionValue(content, "Bundle-Version");
            this._emptyExportPackageBundleSymbolicMap.put(bundleSymbolicName, bundleVersion);
        }
        return this._emptyExportPackageBundleSymbolicMap;
    }

    private boolean _isValidBundleSymbolicName(String dependencyName, String dependencyVersion) throws IOException {
        Map<String, String> emptyExportPackageBundleSymbolicMap = this._getEmptyExportPackageBundleSymbolicMap();
        Set<String> emptyExportPackageBundleSymbolicNames = emptyExportPackageBundleSymbolicMap.keySet();
        if (!dependencyName.startsWith("com.liferay.") || !emptyExportPackageBundleSymbolicNames.contains(dependencyName)) {
            return true;
        }
        return !dependencyVersion.equals(emptyExportPackageBundleSymbolicMap.get(dependencyName));
    }
}

