/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.WhitespaceCheck;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSPWhitespaceCheck
extends WhitespaceCheck {
    private static final Pattern _directiveLinePattern = Pattern.compile("<%@\n?.*%>");
    private static final Pattern _javaSourceInsideJSPLinePattern = Pattern.compile("<%=(.+?)%>");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        content = this._formatWhitespace(fileName, content);
        content = this._formatDirectivesWhitespace(content);
        content = StringUtil.replace(content, new String[]{"<br/>", "@page import", "@tag import", "\"%>", ")%>", "function (", "javascript: ", "){\n", "\n\n\n"}, new String[]{"<br />", "@ page import", "@ tag import", "\" %>", ") %>", "function(", "javascript:", ") {\n", "\n\n"});
        return content;
    }

    private String _formatDirectivesWhitespace(String content) {
        Matcher matcher = _directiveLinePattern.matcher(content);
        while (matcher.find()) {
            String directiveLine = matcher.group();
            String newDirectiveLine = this.formatIncorrectSyntax(directiveLine, " =", "=", false);
            if (directiveLine.equals(newDirectiveLine = this.formatIncorrectSyntax(newDirectiveLine, "= ", "=", false))) continue;
            content = StringUtil.replace(content, directiveLine, newDirectiveLine);
        }
        return content.replaceAll("(\\s(page|taglib))\\s+((import|uri)=)", "$1 $3");
    }

    private String _formatWhitespace(String line, boolean javaSource) {
        String trimmedLine = StringUtil.trimLeading(line);
        line = this.formatWhitespace(line, trimmedLine, javaSource);
        if (javaSource) {
            return line;
        }
        Matcher matcher = _javaSourceInsideJSPLinePattern.matcher(line);
        while (matcher.find()) {
            String linePart = matcher.group(1);
            if (!linePart.startsWith(" ")) {
                return StringUtil.replace(line, matcher.group(), "<%= " + linePart + "%>");
            }
            if (!linePart.endsWith(" ")) {
                return StringUtil.replace(line, matcher.group(), "<%=" + linePart + " %>");
            }
            line = this.formatWhitespace(line, linePart, true);
        }
        return line;
    }

    private String _formatWhitespace(String fileName, String content) throws IOException {
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            String line = null;
            boolean javaSource = false;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                String trimmedLine;
                if (!fileName.endsWith("/jsonws/action.jsp")) {
                    line = this.trimLine(fileName, line);
                }
                if ((trimmedLine = StringUtil.trimLeading(line)).equals("<%") || trimmedLine.equals("<%!")) {
                    javaSource = true;
                } else if (trimmedLine.equals("%>")) {
                    javaSource = false;
                }
                if (!trimmedLine.equals("%>") && line.contains("%>") && !line.contains("--%>") && !line.contains(" %>")) {
                    line = StringUtil.replace(line, "%>", " %>");
                }
                int pos = -1;
                while ((pos = line.indexOf("<%=", pos + 1)) != -1 && pos + 3 != line.length()) {
                    if (line.charAt(pos + 3) == ' ') continue;
                    line = StringUtil.replaceFirst(line, "<%=", "<%= ", pos);
                }
                if (trimmedLine.startsWith("//") || trimmedLine.startsWith("*")) {
                    sb.append(line);
                    sb.append("\n");
                    continue;
                }
                line = this.formatIncorrectSyntax(line, "\t ", "\t", false);
                if ((line = this._formatWhitespace(line, javaSource)).endsWith(">")) {
                    if (line.endsWith("/>")) {
                        if (!trimmedLine.equals("/>") && !line.endsWith(" />")) {
                            line = StringUtil.replaceLast(line, "/>", " />");
                        }
                    } else if (line.endsWith(" >")) {
                        line = StringUtil.replaceLast(line, " >", ">");
                    }
                }
                while (trimmedLine.contains("\t")) {
                    line = StringUtil.replaceLast(line, '\t', " ");
                    trimmedLine = StringUtil.replaceLast(trimmedLine, '\t', " ");
                }
                while (trimmedLine.contains("  ") && !trimmedLine.contains("\"  ") && !fileName.endsWith(".vm")) {
                    line = StringUtil.replaceLast(line, "  ", " ");
                    trimmedLine = StringUtil.replaceLast(trimmedLine, "  ", " ");
                }
                sb.append(line);
                sb.append("\n");
            }
        }
        content = sb.toString();
        if (content.endsWith("\n")) {
            content = content.substring(0, content.length() - 1);
        }
        return content;
    }
}

