/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.JavaSourceUtil;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaBooleanUsageCheck
extends BaseFileCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        content = this._fixIncorrectBooleanUse(content, "setAttribute");
        return content;
    }

    private String _fixIncorrectBooleanUse(String content, String methodName) {
        Pattern pattern = Pattern.compile("\\." + methodName + "\\((.*?)\\);\n", 32);
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            String secondParameterName;
            List<String> parametersList;
            String match;
            if (ToolsUtil.isInsideQuotes(content, matcher.start()) || (match = matcher.group()).contains("\t//") || (parametersList = JavaSourceUtil.getParameterList(match)).size() != 2 || !(secondParameterName = parametersList.get(1)).equals("false") && !secondParameterName.equals("true")) continue;
            String replacement = StringUtil.replaceLast(match, secondParameterName, "Boolean." + StringUtil.toUpperCase(secondParameterName));
            return StringUtil.replace(content, match, replacement);
        }
        return content;
    }
}

