/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.List;

public abstract class MessageCheck
extends BaseCheck {
    private static final String _MSG_INCORRECT_MESSAGE = "message.incorrect";

    protected void checkMessage(String literalStringValue, int lineNo) {
        if (Validator.isNull(literalStringValue) || literalStringValue.endsWith("...")) {
            return;
        }
        String[] parts = literalStringValue.split("\\S\\. [A-Z0-9]");
        if (parts.length == 1 ^ !literalStringValue.endsWith(".")) {
            this.log(lineNo, _MSG_INCORRECT_MESSAGE, new Object[0]);
        }
    }

    protected String getLiteralStringValue(DetailAST exprDetailAST) {
        DetailAST firstChildDetailAST = exprDetailAST.getFirstChild();
        if (firstChildDetailAST.getType() == 139) {
            String s = firstChildDetailAST.getText();
            return s.substring(1, s.length() - 1);
        }
        StringBundler sb = new StringBundler();
        if (firstChildDetailAST.getType() == 125) {
            DetailAST childDetailAST = firstChildDetailAST.getFirstChild();
            do {
                if (childDetailAST.getType() != 139) {
                    return null;
                }
                String s = childDetailAST.getText();
                sb.append(s.substring(1, s.length() - 1));
            } while ((childDetailAST = childDetailAST.getNextSibling()) != null);
            return sb.toString();
        }
        if (firstChildDetailAST.getType() != 27) {
            return null;
        }
        String methodName = DetailASTUtil.getMethodName(firstChildDetailAST);
        if (!methodName.equals("concat")) {
            return null;
        }
        DetailAST elistDetailAST = firstChildDetailAST.findFirstToken(34);
        List<DetailAST> exprDetailASTList = DetailASTUtil.getAllChildTokens(elistDetailAST, false, 28);
        for (DetailAST curExprDetailAST : exprDetailASTList) {
            firstChildDetailAST = curExprDetailAST.getFirstChild();
            if (firstChildDetailAST.getType() != 139) {
                return null;
            }
            String s = firstChildDetailAST.getText();
            sb.append(s.substring(1, s.length() - 1));
        }
        return sb.toString();
    }
}

