/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ReferenceAnnotationCheck
extends BaseCheck {
    private static final String _MSG_INCORRECT_GREEDY_POLICY_OPTION = "greedy.policy.option.incorrect";
    private static final String _MSG_MISSING_DYNAMIC_POLICY_UNBIND = "unbind.dynamic.policy.missing";
    private static final String _MSG_MISSING_STATIC_POLICY_UNBIND = "unbind.static.policy.missing";
    private static final String _MSG_MISSING_VOLATILE = "volatile.missing";
    private static final String _MSG_MOVE_REFERENCE = "reference.move";
    private static final String _MSG_REDUNDANT_DEFAULT_UNBIND = "default.unbind.redundant";
    private static final String _NO_UNBIND = "\"-\"";
    private static final String _POLICY_DYNAMIC = "DYNAMIC";
    private static final String _POLICY_OPTION_GREEDY = "GREEDY";
    private static final String _POLICY_OPTION_RELUCTANT = "RELUCTANT";
    private static final String _POLICY_STATIC = "STATIC";
    private static final Pattern _referenceMethodContentPattern = Pattern.compile("^(\\w+) =\\s+\\w+;$");

    public int[] getDefaultTokens() {
        return new int[]{14};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST != null) {
            return;
        }
        List<String> importNames = DetailASTUtil.getImportNames(detailAST);
        if (!importNames.contains("org.osgi.service.component.annotations.Reference")) {
            return;
        }
        List<DetailAST> detailASTList = DetailASTUtil.getAllChildTokens(detailAST, true, 9, 10);
        for (DetailAST curDetailAST : detailASTList) {
            this._checkReferenceAnnotation(curDetailAST);
        }
    }

    private void _checkDynamicMethod(DetailAST classDefinitionDetailAST, DetailAST methodDefinitionDetailAST, String methodName, String defaultUnbindMethodName) {
        String methodBody = this._getMethodBody(methodDefinitionDetailAST);
        Matcher matcher = _referenceMethodContentPattern.matcher(StringUtil.trim(methodBody));
        if (!matcher.find()) {
            if (!this._containsMethod(classDefinitionDetailAST, defaultUnbindMethodName)) {
                this.log(methodDefinitionDetailAST, _MSG_MISSING_DYNAMIC_POLICY_UNBIND, new Object[0]);
            }
            return;
        }
        String variableName = matcher.group(1);
        List<DetailAST> variableDefinitionDetailASTList = DetailASTUtil.getAllChildTokens(classDefinitionDetailAST, true, 10);
        for (DetailAST variableDefinitionDetailAST : variableDefinitionDetailASTList) {
            DetailAST identDetailAST = variableDefinitionDetailAST.findFirstToken(58);
            if (!variableName.equals(identDetailAST.getText())) continue;
            if (AnnotationUtil.containsAnnotation((DetailAST)variableDefinitionDetailAST, (String)"Reference")) {
                return;
            }
            DetailAST modifiersDetailAST = variableDefinitionDetailAST.findFirstToken(5);
            if (modifiersDetailAST.branchContains(64)) continue;
            this.log(methodDefinitionDetailAST, _MSG_MOVE_REFERENCE, new Object[]{methodName, variableName});
        }
    }

    private void _checkGreedyOption(DetailAST annotationDetailAST, String policyName) {
        String policyOptionName = this._getAnnotationMemberValue(annotationDetailAST, "policyOption", _POLICY_OPTION_RELUCTANT);
        if (policyOptionName.endsWith(_POLICY_OPTION_GREEDY) && policyName.endsWith(_POLICY_STATIC)) {
            this.log(annotationDetailAST, _MSG_INCORRECT_GREEDY_POLICY_OPTION, new Object[0]);
        }
    }

    private void _checkReferenceAnnotation(DetailAST detailAST) {
        DetailAST annotationDetailAST = AnnotationUtil.getAnnotation((DetailAST)detailAST, (String)"Reference");
        if (annotationDetailAST == null) {
            return;
        }
        String policyName = this._getAnnotationMemberValue(annotationDetailAST, "policy", _POLICY_STATIC);
        this._checkGreedyOption(annotationDetailAST, policyName);
        if (detailAST.getType() == 10) {
            this._checkVolatileVariable(detailAST, policyName);
            return;
        }
        DetailAST classDefinitionDetailAST = DetailASTUtil.getParentWithTokenType(detailAST, 14);
        if (classDefinitionDetailAST == null) {
            return;
        }
        String unbindName = this._getAnnotationMemberValue(annotationDetailAST, "unbind", null);
        DetailAST identDetailAST = detailAST.findFirstToken(58);
        String methodName = identDetailAST.getText();
        String defaultUnbindMethodName = this._getDefaultUnbindMethodName(methodName);
        this._checkUnbind(classDefinitionDetailAST, defaultUnbindMethodName, unbindName, policyName, annotationDetailAST.getLineNo());
        if (policyName.endsWith(_POLICY_DYNAMIC) && unbindName == null) {
            this._checkDynamicMethod(classDefinitionDetailAST, detailAST, methodName, defaultUnbindMethodName);
        }
    }

    private void _checkUnbind(DetailAST classDefinitionDetailAST, String defaultUnbindMethodName, String unbindName, String policyName, int lineNo) {
        if (unbindName == null) {
            if (policyName.endsWith(_POLICY_STATIC) && !this._containsMethod(classDefinitionDetailAST, defaultUnbindMethodName)) {
                this.log(lineNo, _MSG_MISSING_STATIC_POLICY_UNBIND, new Object[]{_NO_UNBIND});
            }
        } else if (unbindName.equals("\"" + defaultUnbindMethodName + "\"")) {
            this.log(lineNo, _MSG_REDUNDANT_DEFAULT_UNBIND, new Object[0]);
        } else if (unbindName.equals(_NO_UNBIND) && policyName.endsWith(_POLICY_DYNAMIC)) {
            this.log(lineNo, _MSG_MISSING_DYNAMIC_POLICY_UNBIND, new Object[0]);
        }
    }

    private void _checkVolatileVariable(DetailAST variableDefinitionDetailAST, String policyName) {
        if (!policyName.endsWith(_POLICY_DYNAMIC)) {
            return;
        }
        DetailAST modifiersDetailAST = variableDefinitionDetailAST.findFirstToken(5);
        if (!modifiersDetailAST.branchContains(68)) {
            DetailAST identDetailAST = variableDefinitionDetailAST.findFirstToken(58);
            this.log(identDetailAST, _MSG_MISSING_VOLATILE, new Object[]{identDetailAST.getText()});
        }
    }

    private boolean _containsMethod(DetailAST classDefinitionDetailAST, String methodName) {
        List<DetailAST> methodDefinitionDetailASTList = DetailASTUtil.getAllChildTokens(classDefinitionDetailAST, true, 9);
        for (DetailAST methodDefinitionDetailAST : methodDefinitionDetailASTList) {
            DetailAST identDetailAST = methodDefinitionDetailAST.findFirstToken(58);
            if (!methodName.equals(identDetailAST.getText())) continue;
            return true;
        }
        return false;
    }

    private String _getAnnotationMemberValue(DetailAST anontationDetailAST, String name, String defaultValue) {
        List<DetailAST> annotationMemberValuePairDetailASTList = DetailASTUtil.getAllChildTokens(anontationDetailAST, false, 160);
        for (DetailAST annotationMemberValuePairDetailAST : annotationMemberValuePairDetailASTList) {
            DetailAST identDetailAST = annotationMemberValuePairDetailAST.findFirstToken(58);
            String annotationMemberName = identDetailAST.getText();
            if (!annotationMemberName.equals(name)) continue;
            DetailAST expressionDetailAST = annotationMemberValuePairDetailAST.findFirstToken(28);
            if (expressionDetailAST == null) {
                return null;
            }
            FullIdent expressionIdent = FullIdent.createFullIdentBelow((DetailAST)expressionDetailAST);
            return expressionIdent.getText();
        }
        return defaultValue;
    }

    private String _getDefaultUnbindMethodName(String methodName) {
        if (methodName.startsWith("add")) {
            return StringUtil.replaceFirst(methodName, "add", "remove");
        }
        return "un" + methodName;
    }

    private String _getMethodBody(DetailAST methodDefinitionDetailAST) {
        DetailAST slistDetailAST = methodDefinitionDetailAST.findFirstToken(7);
        int startLineNumber = DetailASTUtil.getStartLineNumber(slistDetailAST);
        int endLineNumber = DetailASTUtil.getEndLineNumber(slistDetailAST);
        StringBundler sb = new StringBundler((endLineNumber - startLineNumber - 1) * 2);
        for (int i = startLineNumber + 1; i < endLineNumber; ++i) {
            sb.append(this.getLine(i - 1));
            sb.append("\n");
        }
        return sb.toString();
    }
}

