/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CSSHexColorsCheck
extends BaseFileCheck {
    private static final Pattern _hexColorPattern = Pattern.compile("#([0-9a-f]+)[\\( ;,]");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        return this._fixHexColors(content);
    }

    private String _fixHexColors(String content) {
        Matcher matcher = _hexColorPattern.matcher(content);
        while (matcher.find()) {
            String hexColor = matcher.group(1);
            if (Validator.isNumber(hexColor) || hexColor.length() < 3) continue;
            content = StringUtil.replace(content, hexColor, StringUtil.toUpperCase(hexColor));
        }
        return content;
    }
}

