/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checks.BaseJavaTermCheck;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaTerm;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaAnnotationsCheck
extends BaseJavaTermCheck {
    private static final Pattern _annotationLineBreakPattern1 = Pattern.compile("[{=]\n.*(\" \\+\n\t*\")");
    private static final Pattern _annotationLineBreakPattern2 = Pattern.compile("=(\n\t*)\"");
    private static final Pattern _arrayPattern = Pattern.compile("=\\s+\\{");
    private static final Pattern _modifierPattern = Pattern.compile("[^\n]\n(\t*)(public|protected|private)");

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) throws IOException {
        return this.formatAnnotations(fileName, (JavaClass)javaTerm, true);
    }

    protected String formatAnnotation(String fileName, JavaClass javaClass, String annotation, String indent) {
        if (!annotation.contains("(")) {
            return annotation;
        }
        annotation = this._fixAnnotationLineBreaks(annotation, indent);
        annotation = this._fixSingleValueArray(annotation);
        return annotation;
    }

    protected String formatAnnotations(String fileName, JavaClass javaClass, boolean sortAnnotations) throws IOException {
        String content = javaClass.getContent();
        if (javaClass.getParentJavaClass() != null) {
            return content;
        }
        List<String> annotationsBlocks = this._getAnnotationsBlocks(content);
        for (String annotationsBlock : annotationsBlocks) {
            String indent = this._getIndent(annotationsBlock);
            String newAnnotationsBlock = this._formatAnnotations(fileName, javaClass, annotationsBlock, indent, sortAnnotations);
            content = StringUtil.replace(content, "\n" + annotationsBlock, "\n" + newAnnotationsBlock);
        }
        return content;
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_CLASS};
    }

    private String _fixAnnotationLineBreaks(String annotation, String indent) {
        Matcher matcher = _annotationLineBreakPattern1.matcher(annotation);
        if (matcher.find()) {
            return StringUtil.replaceFirst(annotation, matcher.group(1), "", matcher.start());
        }
        matcher = _annotationLineBreakPattern2.matcher(annotation);
        if (matcher.find()) {
            return StringUtil.replaceFirst(annotation, matcher.group(1), " ", matcher.start());
        }
        if (annotation.matches(".*\\(\n[\\S\\s]*[^\t\n]\\)\n")) {
            return StringUtil.replaceLast(annotation, ")", "\n" + indent + ")");
        }
        return annotation;
    }

    private String _fixSingleValueArray(String annotation) {
        Matcher matcher = _arrayPattern.matcher(annotation);
        block0: while (matcher.find()) {
            int x = matcher.start();
            if (ToolsUtil.isInsideQuotes(annotation, x)) continue;
            String arrayString = null;
            int y = x;
            do {
                if ((y = annotation.indexOf("}", y + 1)) != -1) continue;
                return annotation;
            } while (ToolsUtil.isInsideQuotes(annotation, y) || this.getLevel(arrayString = annotation.substring(matcher.end() - 1, y + 1), "{", "}") != 0);
            y = -1;
            while ((y = arrayString.indexOf(",", y + 1)) != -1) {
                if (ToolsUtil.isInsideQuotes(arrayString, y)) continue;
                continue block0;
            }
            String replacement = StringUtil.trim(arrayString.substring(1, arrayString.length() - 1));
            if (!Validator.isNotNull(replacement)) continue;
            return StringUtil.replace(annotation, arrayString, replacement);
        }
        return annotation;
    }

    private String _formatAnnotations(String fileName, JavaClass javaClass, String annotationsBlock, String indent, boolean sortAnnotations) throws IOException {
        List<String> annotations = this._splitAnnotations(annotationsBlock, indent);
        String previousAnnotation = null;
        for (String annotation : annotations) {
            String newAnnotation = this.formatAnnotation(fileName, javaClass, annotation, indent);
            if (newAnnotation.contains("(")) {
                newAnnotation = this._formatAnnotations(fileName, javaClass, newAnnotation, indent + "\t\t", false);
            }
            annotationsBlock = StringUtil.replace(annotationsBlock, annotation, newAnnotation);
            if (!sortAnnotations) continue;
            if (Validator.isNotNull(previousAnnotation) && previousAnnotation.compareToIgnoreCase(newAnnotation) > 0) {
                annotationsBlock = StringUtil.replaceFirst(annotationsBlock, previousAnnotation, newAnnotation);
                annotationsBlock = StringUtil.replaceLast(annotationsBlock, newAnnotation, previousAnnotation);
            }
            previousAnnotation = newAnnotation;
        }
        return annotationsBlock;
    }

    private List<String> _getAnnotationsBlocks(String content) {
        ArrayList<String> annotationsBlocks = new ArrayList<String>();
        Matcher matcher = _modifierPattern.matcher(content);
        block0: while (matcher.find()) {
            int lineNumber = this.getLineNumber(content, matcher.end());
            String annotationsBlock = "";
            int i = lineNumber - 1;
            while (true) {
                String line;
                if (Validator.isNull(line = this.getLine(content, i)) || line.matches("\t*(private|public|protected| \\*/).*")) {
                    if (!Validator.isNotNull(annotationsBlock)) continue block0;
                    annotationsBlocks.add(annotationsBlock);
                    continue block0;
                }
                annotationsBlock = line + "\n" + annotationsBlock;
                --i;
            }
        }
        return annotationsBlocks;
    }

    private String _getIndent(String s) {
        StringBundler sb = new StringBundler();
        for (char c : s.toCharArray()) {
            if (c != '\t') break;
            sb.append(c);
        }
        return sb.toString();
    }

    private List<String> _splitAnnotations(String annotationsBlock, String indent) throws IOException {
        ArrayList<String> annotations = new ArrayList<String>();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(annotationsBlock));){
            String annotation = null;
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                if (annotation == null) {
                    if (!line.startsWith(indent + "@")) continue;
                    annotation = line + "\n";
                    continue;
                }
                String lineIndent = this._getIndent(line);
                if (lineIndent.length() < indent.length()) {
                    annotations.add(annotation);
                    annotation = null;
                    continue;
                }
                if (line.startsWith(indent + "@")) {
                    annotations.add(annotation);
                    annotation = line + "\n";
                    continue;
                }
                annotation = annotation + line + "\n";
            }
            if (Validator.isNotNull(annotation)) {
                annotations.add(annotation);
            }
        }
        return annotations;
    }
}

