/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaExceptionCheck
extends BaseFileCheck {
    private static final Pattern _catchExceptionPattern = Pattern.compile("\n(\t+)catch \\((final )?(.+Exception) (.+)\\) \\{\n");
    private static final Pattern _catchExceptionsPattern = Pattern.compile("\n\t+catch \\((?:final )?((\\w+Exception \\|\\s+)+(\\w+Exception\\s+))\\w+\\)");
    private static final Pattern _lowerCaseNumberOrPeriodPattern = Pattern.compile("[a-z0-9.]");
    private static final Pattern _throwsExceptionsPattern = Pattern.compile("\\sthrows ([\\s\\w,]*)[;{]\n");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        content = this._renameVariableNames(content);
        content = this._sortExceptions(content, _throwsExceptionsPattern, ", ");
        content = this._sortExceptions(content, _catchExceptionsPattern, " |");
        return content;
    }

    private String _renameVariableNames(String content) {
        Matcher matcher = _catchExceptionPattern.matcher(content);
        int skipVariableNameCheckEndPos = -1;
        while (matcher.find()) {
            if (Validator.isNotNull(matcher.group(2))) {
                return StringUtil.replaceFirst(content, "final ", "", matcher.start());
            }
            String exceptionClassName = matcher.group(3);
            String exceptionVariableName = matcher.group(4);
            String tabs = matcher.group(1);
            String expectedExceptionVariableName = "e";
            if (!exceptionClassName.contains(" |")) {
                Matcher lowerCaseNumberOrPeriodMatcher = _lowerCaseNumberOrPeriodPattern.matcher(exceptionClassName);
                expectedExceptionVariableName = StringUtil.toLowerCase(lowerCaseNumberOrPeriodMatcher.replaceAll(""));
            }
            Pattern exceptionVariablePattern = Pattern.compile("(\\W)" + exceptionVariableName + "(\\W)");
            int pos = content.indexOf("\n" + tabs + "}", matcher.end() - 1);
            String insideCatchCode = content.substring(matcher.end(), pos + 1);
            if (insideCatchCode.contains("catch (" + exceptionClassName)) {
                skipVariableNameCheckEndPos = pos;
            }
            if (skipVariableNameCheckEndPos >= matcher.start() || expectedExceptionVariableName.equals(exceptionVariableName)) continue;
            String catchExceptionCodeBlock = content.substring(matcher.start(), pos + 1);
            Matcher exceptionVariableMatcher = exceptionVariablePattern.matcher(catchExceptionCodeBlock);
            String catchExceptionReplacement = exceptionVariableMatcher.replaceAll("$1" + expectedExceptionVariableName + "$2");
            return StringUtil.replaceFirst(content, catchExceptionCodeBlock, catchExceptionReplacement, matcher.start() - 1);
        }
        return content;
    }

    private String _sortExceptions(String content, Pattern pattern, String delimeter) {
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            String match = matcher.group();
            String exceptions = matcher.group(1);
            exceptions = StringUtil.replace(exceptions, new String[]{"\t", "\n"}, new String[]{" ", " "});
            String previousException = "";
            for (String exception : StringUtil.split(exceptions, delimeter)) {
                exception = StringUtil.trim(exception);
                if (Validator.isNotNull(previousException) && previousException.compareToIgnoreCase(exception) > 0) {
                    String replacement = match.replaceAll("(\\W)" + exception + "(\\W)", "$1" + previousException + "$2");
                    replacement = replacement.replaceFirst("(\\W)" + previousException + "(\\W)", "$1" + exception + "$2");
                    return this._sortExceptions(StringUtil.replace(content, match, replacement), pattern, delimeter);
                }
                previousException = exception;
            }
        }
        return content;
    }
}

