/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class IndentationCheck
extends BaseCheck {
    private static final int[] _ARITHMETIC_OPERATORS = new int[]{127, 126, 128, 125, 60};
    private static final String _MSG_INCORRECT_INDENTATION = "indentation.incorrect";
    private static final String _MSG_INCORRECT_INDENTATION_INSIDE_CHAIN = "indentation.inside.chain.incorrect";

    public int[] getDefaultTokens() {
        return new int[]{162, 29, 170, 145, 182, 138, 43, 175, 18, 39, 172, 58, 19, 30, 129, 11, 50, 86, 51, 93, 96, 52, 69, 87, 94, 85, 57, 92, 134, 97, 55, 91, 83, 54, 56, 136, 135, 61, 63, 62, 88, 53, 64, 79, 89, 67, 78, 90, 81, 133, 95, 49, 84, 132, 76, 142, 140, 137, 141, 16, 73, 77, 144, 152, 12, 139, 42, 23, 31, 167};
    }

    public boolean isCommentNodesRequired() {
        return true;
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        int leadingTabCount;
        if (!DetailASTUtil.isAtLineStart(detailAST, this.getLine(DetailASTUtil.getStartLineNumber(detailAST) - 1)) || this._isCatchStatementParameter(detailAST) || this._isInsideChainedConcatMethod(detailAST) || this._isInsideDoIfOrWhileStatementCriterium(detailAST) || this._isInsideMethodParameterDeclaration(detailAST)) {
            return;
        }
        int expectedTabCount = this._getExpectedTabCount(detailAST);
        if (expectedTabCount != (leadingTabCount = this._getLeadingTabCount(detailAST))) {
            if (this._isInsideChain(detailAST)) {
                this.log(detailAST, _MSG_INCORRECT_INDENTATION_INSIDE_CHAIN, new Object[0]);
            } else {
                this.log(detailAST, _MSG_INCORRECT_INDENTATION, new Object[]{leadingTabCount, expectedTabCount});
            }
        }
    }

    private int _addExtraTabForExtendsOrImplements(int expectedTabCount, DetailAST detailAST) {
        DetailAST parentDetailAST = detailAST;
        DetailAST grandParentDetailAST = parentDetailAST.getParent();
        while (grandParentDetailAST != null) {
            if (grandParentDetailAST.getType() == 18 || grandParentDetailAST.getType() == 19) {
                DetailAST previousSiblingDetailAST = parentDetailAST.getPreviousSibling();
                while (true) {
                    int lineNo;
                    if (previousSiblingDetailAST == null) {
                        return expectedTabCount;
                    }
                    if (previousSiblingDetailAST.getType() == 74 && (lineNo = grandParentDetailAST.getLineNo()) < detailAST.getLineNo()) {
                        return expectedTabCount + 1;
                    }
                    previousSiblingDetailAST = previousSiblingDetailAST.getPreviousSibling();
                }
            }
            parentDetailAST = grandParentDetailAST;
            grandParentDetailAST = grandParentDetailAST.getParent();
        }
        return expectedTabCount;
    }

    private int _addExtraTabForForStatement(int expectedTabCount, DetailAST detailAST) {
        DetailAST parentDetailAST = this._findParent(detailAST, 91);
        if (parentDetailAST != null && parentDetailAST.branchContains(156)) {
            return expectedTabCount + 1;
        }
        return expectedTabCount;
    }

    private int _addExtraTabForParameterWithThrows(int expectedTabCount, DetailAST detailAST) {
        DetailAST parentDetailAST = detailAST;
        DetailAST grandParentDetailAST = parentDetailAST.getParent();
        while (grandParentDetailAST != null) {
            if (grandParentDetailAST.getType() == 8 || grandParentDetailAST.getType() == 9) {
                DetailAST literalThrowsDetailAST = grandParentDetailAST.findFirstToken(81);
                if (literalThrowsDetailAST == null) {
                    return expectedTabCount;
                }
                int literalThrowsLineNo = literalThrowsDetailAST.getLineNo();
                int modifierLineNo = this._getModifierLineNo(grandParentDetailAST);
                if (parentDetailAST.getType() == 20 || detailAST.getLineNo() < literalThrowsLineNo && detailAST.getLineNo() > modifierLineNo) {
                    return expectedTabCount + 1;
                }
                return expectedTabCount;
            }
            parentDetailAST = grandParentDetailAST;
            grandParentDetailAST = grandParentDetailAST.getParent();
        }
        return expectedTabCount;
    }

    private int _addExtraTabForSwitch(int expectedTabCount, DetailAST detailAST) {
        if (detailAST.getType() == 93 || detailAST.getType() == 94) {
            return expectedTabCount;
        }
        DetailAST parentDetailAST = detailAST.getParent();
        while (parentDetailAST != null) {
            if (parentDetailAST.getType() == 33) {
                return expectedTabCount + 1;
            }
            parentDetailAST = parentDetailAST.getParent();
        }
        return expectedTabCount;
    }

    private int _addExtraTabForTryStatement(int expectedTabCount, DetailAST detailAST) {
        DetailAST parentDetailAST = detailAST.getParent();
        while (parentDetailAST != null) {
            DetailAST previousSiblingDetailAST;
            if (parentDetailAST.getType() == 178 && (previousSiblingDetailAST = parentDetailAST.getPreviousSibling()) != null) {
                return expectedTabCount;
            }
            if (parentDetailAST.getType() == 176) {
                if ((parentDetailAST = parentDetailAST.getParent()).getType() != 95) continue;
                return expectedTabCount + 1;
            }
            parentDetailAST = parentDetailAST.getParent();
        }
        return expectedTabCount;
    }

    private int _addExtraTabsForLambda(int expectedTabCount, DetailAST detailAST) {
        DetailAST parentDetailAST = detailAST.getParent();
        while (parentDetailAST != null) {
            DetailAST grandParentDetailAST;
            if (parentDetailAST.getType() == 20 && (parentDetailAST = parentDetailAST.getParent()).getType() == 181 && (grandParentDetailAST = parentDetailAST.getParent()).getType() == 88) {
                return expectedTabCount + 1;
            }
            if (parentDetailAST.getType() == 7) {
                DetailAST firstChildDetailAST;
                if ((parentDetailAST = parentDetailAST.getParent()).getType() != 181 || (firstChildDetailAST = parentDetailAST.getFirstChild()).getLineNo() != parentDetailAST.getLineNo()) continue;
                expectedTabCount += this._getLineBreakTabs(parentDetailAST);
                continue;
            }
            parentDetailAST = parentDetailAST.getParent();
        }
        return expectedTabCount;
    }

    private int _addExtraTabsForLiteralNew(int expectedTabCount, DetailAST detailAST) {
        DetailAST parentDetailAST = detailAST.getParent();
        while (parentDetailAST != null) {
            if (parentDetailAST.getType() == 6) {
                if ((parentDetailAST = parentDetailAST.getParent()).getType() != 136) continue;
                expectedTabCount += this._getLineBreakTabs(parentDetailAST);
                continue;
            }
            parentDetailAST = parentDetailAST.getParent();
        }
        return expectedTabCount;
    }

    private Set<Integer> _addTabsForArithmeticOperators(Set<Integer> lineNumbers, int lineNumber, DetailAST detailAST) {
        DetailAST firstChildDetailAST = detailAST;
        while (true) {
            int lineNo;
            if ((lineNo = firstChildDetailAST.getLineNo()) < lineNumber) {
                lineNumbers.add(lineNo);
            }
            if (!ArrayUtil.contains(_ARITHMETIC_OPERATORS, firstChildDetailAST.getType())) break;
            firstChildDetailAST = firstChildDetailAST.getFirstChild();
        }
        return lineNumbers;
    }

    private Set<Integer> _addTabsForDot(Set<Integer> lineNumbers, int lineNumber, DetailAST detailAST) {
        if (detailAST == null) {
            return lineNumbers;
        }
        DetailAST firstChildDetailAST = detailAST;
        while (firstChildDetailAST.getType() == 59) {
            int lineNo = firstChildDetailAST.getLineNo();
            if (lineNo < lineNumber) {
                lineNumbers.add(lineNo);
            }
            firstChildDetailAST = firstChildDetailAST.getFirstChild();
        }
        return lineNumbers;
    }

    private Set<Integer> _addTabsForGenerics(Set<Integer> lineNumbers, int lineNumber, DetailAST detailAST) {
        if (detailAST == null) {
            return lineNumbers;
        }
        List<DetailAST> genericStartDetailASTList = DetailASTUtil.getAllChildTokens(detailAST, true, 172);
        for (DetailAST genericStartDetailAST : genericStartDetailASTList) {
            DetailAST exprDetailAST;
            DetailAST commaDetailAST;
            DetailAST grandParentDetailAST;
            DetailAST nextSiblingDetailAST;
            DetailAST parentDetailAST;
            DetailAST genericEndDetailAST;
            String line;
            if (!DetailASTUtil.isAtLineStart(genericStartDetailAST, line = this.getLine(DetailASTUtil.getStartLineNumber(genericStartDetailAST) - 1)) || (genericEndDetailAST = (parentDetailAST = genericStartDetailAST.getParent()).findFirstToken(173)).getLineNo() < lineNumber && genericStartDetailAST.getLineNo() < lineNumber && (nextSiblingDetailAST = (grandParentDetailAST = parentDetailAST.getParent()).getNextSibling()) != null && nextSiblingDetailAST.getType() == 74) continue;
            int lineNo = genericStartDetailAST.getLineNo() - 1;
            if (lineNo < lineNumber) {
                lineNumbers.add(lineNo);
            }
            if ((commaDetailAST = parentDetailAST.findFirstToken(74)) != null && genericEndDetailAST.getLineNo() != genericStartDetailAST.getLineNo() || (exprDetailAST = DetailASTUtil.getParentWithTokenType(genericStartDetailAST, 28)) != null && !lineNumbers.contains(DetailASTUtil.getStartLineNumber(exprDetailAST)) || (lineNo = genericStartDetailAST.getLineNo()) >= lineNumber) continue;
            lineNumbers.add(lineNo);
        }
        List<DetailAST> genericEndtASTList = DetailASTUtil.getAllChildTokens(detailAST, true, 173);
        for (DetailAST genericEndDetailAST : genericEndtASTList) {
            int lineNo;
            DetailAST exprDetailAST;
            String line;
            if (!DetailASTUtil.isAtLineEnd(genericEndDetailAST, line = this.getLine(genericEndDetailAST.getLineNo() - 1)) || (exprDetailAST = DetailASTUtil.getParentWithTokenType(genericEndDetailAST, 28)) != null && !lineNumbers.contains(DetailASTUtil.getStartLineNumber(exprDetailAST)) || (lineNo = genericEndDetailAST.getLineNo()) >= lineNumber) continue;
            lineNumbers.add(lineNo);
        }
        return lineNumbers;
    }

    private Set<Integer> _addTabsForTypecast(Set<Integer> lineNumbers, int lineNumber, DetailAST detailAST) {
        DetailAST previousSiblingDetailAST = detailAST.getPreviousSibling();
        if (previousSiblingDetailAST == null || previousSiblingDetailAST.getType() != 23) {
            return lineNumbers;
        }
        int lineNo = previousSiblingDetailAST.getLineNo();
        if (lineNo < lineNumber) {
            lineNumbers.add(lineNo);
        }
        return lineNumbers;
    }

    private int _adjustTabCount(int tabCount, DetailAST detailAST) {
        tabCount = this._adjustTabCountForChains(tabCount, detailAST);
        tabCount = this._adjustTabCountForEndOfLineLogicalOperator(tabCount, detailAST);
        return tabCount;
    }

    private int _adjustTabCountForChains(int tabCount, DetailAST detailAST) {
        boolean checkChaining = false;
        int methodCallLineNumber = -1;
        DetailAST parentDetailAST = detailAST;
        while (parentDetailAST != null && parentDetailAST.getType() != 22 && parentDetailAST.getType() != 6 && parentDetailAST.getType() != 7) {
            String line;
            if (checkChaining && (line = StringUtil.trim(this.getLine(parentDetailAST.getLineNo() - 1))).endsWith("(") && parentDetailAST.getLineNo() < methodCallLineNumber) {
                DetailAST rparenDetailAST = null;
                DetailAST methodCallDetailAST = this._findDetailAST(parentDetailAST, parentDetailAST.getLineNo(), 27);
                if (methodCallDetailAST != null) {
                    rparenDetailAST = methodCallDetailAST.findFirstToken(77);
                } else {
                    DetailAST lparenDetailAST = this._findDetailAST(parentDetailAST, parentDetailAST.getLineNo(), 76);
                    DetailAST nextSiblingDetailAST = lparenDetailAST.getNextSibling();
                    while (true) {
                        if (nextSiblingDetailAST == null || nextSiblingDetailAST.getType() == 77) {
                            rparenDetailAST = nextSiblingDetailAST;
                            break;
                        }
                        nextSiblingDetailAST = nextSiblingDetailAST.getNextSibling();
                    }
                }
                if (rparenDetailAST != null && rparenDetailAST.getLineNo() < detailAST.getLineNo()) {
                    --tabCount;
                }
                checkChaining = false;
            }
            if (parentDetailAST.getType() == 27 && (line = StringUtil.trim(this.getLine(parentDetailAST.getLineNo() - 1))).startsWith(").") && parentDetailAST.getLineNo() < detailAST.getLineNo()) {
                checkChaining = true;
                methodCallLineNumber = parentDetailAST.getLineNo();
            }
            parentDetailAST = parentDetailAST.getParent();
        }
        return tabCount;
    }

    private int _adjustTabCountForEndOfLineLogicalOperator(int tabCount, DetailAST detailAST) {
        DetailAST parentDetailAST = detailAST;
        while (parentDetailAST != null && parentDetailAST.getType() != 22 && parentDetailAST.getType() != 6 && parentDetailAST.getType() != 7) {
            if ((parentDetailAST.getType() == 114 || parentDetailAST.getType() == 112 || parentDetailAST.getType() == 113 || parentDetailAST.getType() == 111 || parentDetailAST.getType() == 110) && parentDetailAST.getLineNo() < detailAST.getLineNo()) {
                String text = parentDetailAST.getText();
                String line = this.getLine(parentDetailAST.getLineNo() - 1);
                String trimmedLine = StringUtil.trim(line);
                if (!trimmedLine.startsWith("return ") && parentDetailAST.getColumnNo() + text.length() == line.length()) {
                    --tabCount;
                }
            }
            parentDetailAST = parentDetailAST.getParent();
        }
        return tabCount;
    }

    private DetailAST _findDetailAST(DetailAST parentDetailAST, int lineNo, int type) {
        if (parentDetailAST.getType() == type) {
            return parentDetailAST;
        }
        List<DetailAST> methodCallDetailASTList = DetailASTUtil.getAllChildTokens(parentDetailAST, true, type);
        for (DetailAST methodCallDetailAST : methodCallDetailASTList) {
            if (methodCallDetailAST.getLineNo() != lineNo) continue;
            return methodCallDetailAST;
        }
        return null;
    }

    private DetailAST _findParent(DetailAST detailAST, int type) {
        DetailAST matchDetailAST = null;
        DetailAST parentDetailAST = detailAST.getParent();
        while (parentDetailAST != null && parentDetailAST.getType() != 6 && parentDetailAST.getType() != 7) {
            if (parentDetailAST.getType() == type) {
                matchDetailAST = parentDetailAST;
            }
            parentDetailAST = parentDetailAST.getParent();
        }
        return matchDetailAST;
    }

    private int _getChainLevel(DetailAST detailAST) {
        int level = 1;
        while (true) {
            DetailAST firstChildDetailAST = detailAST.getFirstChild();
            if (detailAST.getType() == 27 && firstChildDetailAST.getType() == 59) {
                detailAST = firstChildDetailAST;
                continue;
            }
            if (detailAST.getType() != 59 || firstChildDetailAST.getType() != 27) break;
            ++level;
            detailAST = firstChildDetailAST;
        }
        return level;
    }

    private int _getExpectedTabCount(DetailAST detailAST) {
        String previousLine;
        DetailAST previousSiblingDetailAST = detailAST.getPreviousSibling();
        if (previousSiblingDetailAST != null && previousSiblingDetailAST.getType() == 74 && DetailASTUtil.isAtLineStart(previousSiblingDetailAST = previousSiblingDetailAST.getPreviousSibling(), previousLine = this.getLine(DetailASTUtil.getStartLineNumber(previousSiblingDetailAST) - 1))) {
            return this._getExpectedTabCount(previousSiblingDetailAST);
        }
        int expectedTabCount = this._getLevel(detailAST) + this._getLineBreakTabs(detailAST);
        expectedTabCount = this._addExtraTabForExtendsOrImplements(expectedTabCount, detailAST);
        expectedTabCount = this._addExtraTabForForStatement(expectedTabCount, detailAST);
        expectedTabCount = this._addExtraTabsForLambda(expectedTabCount, detailAST);
        expectedTabCount = this._addExtraTabsForLiteralNew(expectedTabCount, detailAST);
        expectedTabCount = this._addExtraTabForParameterWithThrows(expectedTabCount, detailAST);
        expectedTabCount = this._addExtraTabForSwitch(expectedTabCount, detailAST);
        expectedTabCount = this._addExtraTabForTryStatement(expectedTabCount, detailAST);
        if (detailAST.getType() == 182 || detailAST.getType() == 73 || detailAST.getType() == 77) {
            return expectedTabCount - 1;
        }
        return expectedTabCount;
    }

    private int _getLeadingTabCount(DetailAST detailAST) {
        String line = this.getLine(DetailASTUtil.getStartLineNumber(detailAST) - 1);
        int leadingTabCount = 0;
        while (line.startsWith("\t")) {
            line = line.substring(1);
            ++leadingTabCount;
        }
        return leadingTabCount;
    }

    private int _getLevel(DetailAST detailAST) {
        int level = 0;
        DetailAST parentDetailAST = detailAST.getParent();
        while (parentDetailAST != null) {
            if (parentDetailAST.getType() == 6 || parentDetailAST.getType() == 7) {
                ++level;
            }
            parentDetailAST = parentDetailAST.getParent();
        }
        return level;
    }

    private int _getLineBreakTabs(DetailAST detailAST) {
        if (detailAST.getType() == 175 || detailAST.getType() == 96 || detailAST.getType() == 92 || detailAST.getType() == 97) {
            return 0;
        }
        Set<Integer> lineNumbers = new HashSet<Integer>();
        DetailAST childDetailAST = null;
        DetailAST parentDetailAST = detailAST;
        while (parentDetailAST != null && parentDetailAST.getType() != 22 && parentDetailAST.getType() != 6 && parentDetailAST.getType() != 7) {
            DetailAST colonDetailAST;
            int lineNo;
            int lineNo2;
            if (parentDetailAST.getType() == 157 || parentDetailAST.getType() == 161 || parentDetailAST.getType() == 14 || parentDetailAST.getType() == 8 || parentDetailAST.getType() == 155 || parentDetailAST.getType() == 154 || parentDetailAST.getType() == 15 || parentDetailAST.getType() == 9 || parentDetailAST.getType() == 5 || parentDetailAST.getType() == 10) {
                DetailAST nameDetailAST;
                DetailAST typeDetailAST = parentDetailAST.findFirstToken(13);
                int lineNo3 = this._getModifierLineNo(parentDetailAST);
                if (lineNo3 == -1 && typeDetailAST != null) {
                    lineNo3 = typeDetailAST.getLineNo();
                }
                if (lineNo3 != -1 && lineNo3 < detailAST.getLineNo()) {
                    lineNumbers.add(lineNo3);
                }
                if ((parentDetailAST.getType() == 14 || parentDetailAST.getType() == 155 || parentDetailAST.getType() == 154 || parentDetailAST.getType() == 15) && (lineNo3 = (nameDetailAST = parentDetailAST.findFirstToken(58)).getLineNo()) < detailAST.getLineNo()) {
                    lineNumbers.add(lineNo3);
                }
                lineNumbers = this._addTabsForGenerics(lineNumbers, detailAST.getLineNo(), typeDetailAST);
                DetailAST typeParametersDetailAST = parentDetailAST.findFirstToken(165);
                lineNumbers = this._addTabsForGenerics(lineNumbers, detailAST.getLineNo(), typeParametersDetailAST);
            } else if (parentDetailAST.getType() == 34 || parentDetailAST.getType() == 20) {
                int lineNo4;
                String line;
                DetailAST lParenDetailAST = parentDetailAST.getPreviousSibling();
                if (lParenDetailAST != null && lParenDetailAST.getType() == 76 && !DetailASTUtil.isAtLineStart(lParenDetailAST, line = this.getLine(DetailASTUtil.getStartLineNumber(lParenDetailAST) - 1)) && (lineNo4 = lParenDetailAST.getLineNo()) < detailAST.getLineNo()) {
                    lineNumbers.add(lineNo4);
                }
            } else if (parentDetailAST.getType() == 163 || parentDetailAST.getType() == 165) {
                int lineNo5;
                DetailAST commaDetailAST = parentDetailAST.findFirstToken(74);
                if ((commaDetailAST == null || commaDetailAST.getLineNo() != parentDetailAST.getLineNo() && commaDetailAST.getLineNo() >= detailAST.getLineNo()) && (lineNo5 = parentDetailAST.getLineNo()) < detailAST.getLineNo()) {
                    lineNumbers.add(lineNo5);
                }
            } else if (parentDetailAST.getType() != 33 && (lineNo2 = parentDetailAST.getLineNo()) < detailAST.getLineNo()) {
                lineNumbers.add(lineNo2);
            }
            DetailAST dotDetailAST = parentDetailAST.findFirstToken(59);
            lineNumbers = this._addTabsForDot(lineNumbers, detailAST.getLineNo(), dotDetailAST);
            if (parentDetailAST.getType() == 18 || parentDetailAST.getType() == 19) {
                for (DetailAST previousSiblingDetailAST = childDetailAST; previousSiblingDetailAST != null; previousSiblingDetailAST = previousSiblingDetailAST.getPreviousSibling()) {
                    if (previousSiblingDetailAST.getType() != 58) continue;
                    int lineNo6 = previousSiblingDetailAST.getLineNo();
                    if (lineNo6 >= detailAST.getLineNo()) break;
                    lineNumbers.add(lineNo6);
                    break;
                }
            }
            if (parentDetailAST.getType() == 156) {
                int lineNo7;
                DetailAST colonDetailAST2 = parentDetailAST.findFirstToken(82);
                if (colonDetailAST2 != null && (lineNo7 = colonDetailAST2.getLineNo()) < detailAST.getLineNo()) {
                    lineNumbers.add(lineNo7);
                }
                lineNumbers = this._addTabsForGenerics(lineNumbers, detailAST.getLineNo(), parentDetailAST);
            }
            if (parentDetailAST.getType() == 21) {
                lineNumbers = this._addTabsForGenerics(lineNumbers, detailAST.getLineNo(), parentDetailAST);
            }
            if (parentDetailAST.getType() == 109 && (lineNo = (colonDetailAST = parentDetailAST.findFirstToken(82)).getLineNo()) < detailAST.getLineNo()) {
                lineNumbers.add(lineNo);
            }
            if (ArrayUtil.contains(_ARITHMETIC_OPERATORS, parentDetailAST.getType())) {
                lineNumbers = this._addTabsForArithmeticOperators(lineNumbers, detailAST.getLineNo(), parentDetailAST);
            }
            if (parentDetailAST.getType() == 13) {
                lineNumbers = this._addTabsForTypecast(lineNumbers, detailAST.getLineNo(), parentDetailAST);
                lineNumbers = this._addTabsForGenerics(lineNumbers, detailAST.getLineNo(), parentDetailAST);
            }
            if (parentDetailAST.getType() == 23) {
                int lineNo8;
                String line;
                DetailAST rparenDetailAST = parentDetailAST.findFirstToken(77);
                if (DetailASTUtil.isAtLineEnd(rparenDetailAST, line = this.getLine(rparenDetailAST.getLineNo() - 1)) && (lineNo8 = rparenDetailAST.getLineNo()) < detailAST.getLineNo()) {
                    lineNumbers.add(lineNo8);
                }
                DetailAST typeDetailAST = parentDetailAST.findFirstToken(13);
                lineNumbers = this._addTabsForGenerics(lineNumbers, detailAST.getLineNo(), typeDetailAST);
            }
            if (parentDetailAST.getType() == 159) {
                if ((parentDetailAST = parentDetailAST.getParent()).getType() != 5 || this._findParent(parentDetailAST, 21) != null) continue;
                return this._adjustTabCount(lineNumbers.size(), detailAST);
            }
            childDetailAST = parentDetailAST;
            parentDetailAST = parentDetailAST.getParent();
        }
        return this._adjustTabCount(lineNumbers.size(), detailAST);
    }

    private int _getModifierLineNo(DetailAST detailAST) {
        DetailAST modifiersDetailAST = detailAST.findFirstToken(5);
        if (modifiersDetailAST == null) {
            return -1;
        }
        DetailAST modifierDetailAST = modifiersDetailAST.findFirstToken(61);
        if (modifierDetailAST == null) {
            modifierDetailAST = modifiersDetailAST.findFirstToken(63);
        }
        if (modifierDetailAST == null) {
            modifierDetailAST = modifiersDetailAST.findFirstToken(62);
        }
        if (modifierDetailAST != null) {
            return modifierDetailAST.getLineNo();
        }
        return -1;
    }

    private boolean _isCatchStatementParameter(DetailAST detailAST) {
        DetailAST parentDetailAST = detailAST.getParent();
        while (true) {
            if (parentDetailAST == null) {
                return false;
            }
            if (parentDetailAST.getType() != 21) {
                parentDetailAST = parentDetailAST.getParent();
                continue;
            }
            if ((parentDetailAST = parentDetailAST.getParent()).getType() == 96) break;
        }
        return true;
    }

    private boolean _isConcatMethod(DetailAST detailAST) {
        if (detailAST.getType() != 27) {
            return false;
        }
        DetailAST firstChildDetailAST = detailAST.getFirstChild();
        if (firstChildDetailAST == null || firstChildDetailAST.getType() != 59) {
            return false;
        }
        DetailAST lastChildDetailAST = firstChildDetailAST.getLastChild();
        if (lastChildDetailAST == null || lastChildDetailAST.getType() != 58) {
            return false;
        }
        String name = lastChildDetailAST.getText();
        return name.equals("concat");
    }

    private boolean _isInsideChain(DetailAST detailAST) {
        DetailAST parentDetailAST = detailAST.getParent();
        while (parentDetailAST != null && parentDetailAST.getType() != 7) {
            if (parentDetailAST.getType() == 27 && this._getChainLevel(parentDetailAST) > 2) {
                return true;
            }
            parentDetailAST = parentDetailAST.getParent();
        }
        return false;
    }

    private boolean _isInsideChainedConcatMethod(DetailAST detailAST) {
        DetailAST parentDetailAST = detailAST.getParent();
        while (parentDetailAST != null) {
            if (!this._isConcatMethod(parentDetailAST)) {
                parentDetailAST = parentDetailAST.getParent();
                continue;
            }
            DetailAST firstChildDetailAST = parentDetailAST.getFirstChild();
            if (this._isConcatMethod(firstChildDetailAST = firstChildDetailAST.getFirstChild())) {
                return true;
            }
            parentDetailAST = parentDetailAST.getParent();
        }
        return false;
    }

    private boolean _isInsideDoIfOrWhileStatementCriterium(DetailAST detailAST) {
        DetailAST parentDetailAST = detailAST.getParent();
        while (true) {
            if (parentDetailAST == null) {
                return false;
            }
            if (parentDetailAST.getType() != 28) {
                parentDetailAST = parentDetailAST.getParent();
                continue;
            }
            if ((parentDetailAST = parentDetailAST.getParent()).getType() == 85 || parentDetailAST.getType() == 83 || parentDetailAST.getType() == 84) break;
        }
        return true;
    }

    private boolean _isInsideMethodParameterDeclaration(DetailAST detailAST) {
        DetailAST parentDetailAST = detailAST.getParent();
        while (true) {
            if (parentDetailAST == null) {
                return false;
            }
            if (parentDetailAST.getType() == 21) break;
            parentDetailAST = parentDetailAST.getParent();
        }
        parentDetailAST = parentDetailAST.getParent();
        if (parentDetailAST.getType() != 20) {
            return false;
        }
        return (parentDetailAST = parentDetailAST.getParent()).getType() == 8 || parentDetailAST.getType() == 9;
    }
}

