/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.List;

public class ParsePrimitiveTypeCheck
extends BaseCheck {
    private static final String _MSG_USE_GETTER_UTIL_METHOD = "getter.util.method.use";

    public int[] getDefaultTokens() {
        return new int[]{8, 9};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        if (this.isRunOutsidePortalExclude()) {
            return;
        }
        this._checkParseMethodCall(detailAST, "Double", "parseDouble", "getDouble");
        this._checkParseMethodCall(detailAST, "Float", "parseFloat", "getFloat");
        this._checkParseMethodCall(detailAST, "Integer", "parseInt", "getInteger");
        this._checkParseMethodCall(detailAST, "Long", "parseLong", "getLong");
        this._checkParseMethodCall(detailAST, "Short", "parseShort", "getShort");
    }

    /*
     * Unable to fully structure code
     */
    private boolean _catchesException(DetailAST methodCallDetailAST, String ... exceptionNames) {
        parentDetailAST = methodCallDetailAST.getParent();
        block0: while (true) {
            if (parentDetailAST == null) {
                return false;
            }
            if (parentDetailAST.getType() != 95) {
                parentDetailAST = parentDetailAST.getParent();
                continue;
            }
            literalCatchDetailAST = parentDetailAST.findFirstToken(96);
            parentDetailAST = parentDetailAST.getParent();
            if (literalCatchDetailAST == null) continue;
            parameterDefinitionDetailAST = literalCatchDetailAST.findFirstToken(21);
            typeDetailAST = parameterDefinitionDetailAST.findFirstToken(13);
            identDetailASTList = DetailASTUtil.getAllChildTokens(typeDetailAST, true, new int[]{58});
            var8_8 = identDetailASTList.iterator();
            do {
                if (var8_8.hasNext()) ** break;
                continue block0;
            } while (!ArrayUtil.contains(exceptionNames, (identDetailAST = var8_8.next()).getText()));
            break;
        }
        return true;
    }

    private void _checkParseMethodCall(DetailAST detailAST, String className, String methodName, String getterUtilMethodName) {
        List<DetailAST> methodCallDetailASTList = DetailASTUtil.getMethodCalls(detailAST, className, methodName);
        for (DetailAST methodCallDetailAST : methodCallDetailASTList) {
            DetailAST elistDetailAST = methodCallDetailAST.findFirstToken(34);
            List<DetailAST> exprDetailASTList = DetailASTUtil.getAllChildTokens(elistDetailAST, false, 28);
            if (exprDetailASTList.size() != 1 || this._catchesException(methodCallDetailAST, "Exception", "NumberFormatException")) continue;
            this.log(methodCallDetailAST, _MSG_USE_GETTER_UTIL_METHOD, new Object[]{getterUtilMethodName, className, methodName});
        }
    }
}

