/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.List;

public class UnusedParameterCheck
extends BaseCheck {
    private static final String _MSG_UNUSED_PARAMETER = "parameter.unused";

    public int[] getDefaultTokens() {
        return new int[]{14, 154, 15};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST != null) {
            return;
        }
        List<DetailAST> constructorsAndMethodsASTList = DetailASTUtil.getAllChildTokens(detailAST, true, 8, 9);
        for (DetailAST constructorOrMethodDetailAST : constructorsAndMethodsASTList) {
            this._checkUnusedParameters(detailAST, constructorOrMethodDetailAST);
        }
    }

    private void _checkUnusedParameters(DetailAST classDetailAST, DetailAST detailAST) {
        DetailAST modifiersDetailAST = detailAST.findFirstToken(5);
        if (!modifiersDetailAST.branchContains(61)) {
            return;
        }
        DetailAST nameDetailAST = detailAST.findFirstToken(58);
        String name = nameDetailAST.getText();
        if (name.equals("readObject") || name.equals("writeObject")) {
            return;
        }
        List<String> parameterNames = DetailASTUtil.getParameterNames(detailAST);
        if (parameterNames.isEmpty()) {
            return;
        }
        DetailAST statementsDetailAST = detailAST.findFirstToken(7);
        List<DetailAST> allIdentsAST = DetailASTUtil.getAllChildTokens(statementsDetailAST, true, 58);
        block0: for (String parameterName : DetailASTUtil.getParameterNames(detailAST)) {
            for (DetailAST identDetailAST : allIdentsAST) {
                if (!parameterName.equals(identDetailAST.getText())) continue;
                continue block0;
            }
            if (this._isReferencedMethod(classDetailAST, detailAST)) continue;
            this.log(detailAST, _MSG_UNUSED_PARAMETER, new Object[]{parameterName});
        }
    }

    private boolean _isReferencedMethod(DetailAST classDetailAST, DetailAST detailAST) {
        List<DetailAST> methodReferenceDetailASTList = DetailASTUtil.getAllChildTokens(classDetailAST, true, 180);
        if (methodReferenceDetailASTList.isEmpty()) {
            return false;
        }
        DetailAST nameDetailAST = detailAST.findFirstToken(58);
        String name = nameDetailAST.getText();
        for (DetailAST methodReferenceDetailAST : methodReferenceDetailASTList) {
            for (DetailAST identDetailAST : DetailASTUtil.getAllChildTokens(methodReferenceDetailAST, true, 58)) {
                if (!name.equals(identDetailAST.getText())) continue;
                return true;
            }
        }
        return false;
    }
}

