/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.util.BNDSourceUtil;
import com.liferay.source.formatter.checks.util.SourceUtil;
import com.liferay.source.formatter.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.TreeMap;

public class ModulesPropertiesUtil {
    private static final String[] _SKIP_DIR_NAMES = new String[]{".git", ".gradle", ".idea", ".m2", ".settings", "bin", "build", "classes", "dependencies", "node_modules", "private", "sdk", "sql", "src", "test", "test-classes", "test-coverage", "test-results", "tmp"};

    public static String getContent(File portalDir) throws IOException {
        StringBundler sb = new StringBundler();
        Map<String, String> bundleVersionsMap = ModulesPropertiesUtil.getBundleVersionsMap(portalDir);
        for (Map.Entry<String, String> entry : bundleVersionsMap.entrySet()) {
            sb.append(entry.getKey());
            sb.append("=");
            sb.append(entry.getValue());
            sb.append("\n");
        }
        if (!bundleVersionsMap.isEmpty()) {
            sb.setIndex(sb.index() - 1);
        }
        return sb.toString();
    }

    protected static Map<String, String> getBundleVersionsMap(File portalDir) throws IOException {
        if (portalDir == null) {
            return Collections.emptyMap();
        }
        final ArrayList files = new ArrayList();
        Files.walkFileTree(portalDir.toPath(), EnumSet.noneOf(FileVisitOption.class), 15, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dirPath, BasicFileAttributes basicFileAttributes) {
                String dirName = String.valueOf(dirPath.getFileName());
                if (ArrayUtil.contains(_SKIP_DIR_NAMES, dirName)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                Path path = dirPath.resolve(".gitrepo");
                if (Files.exists(path, new LinkOption[0])) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                path = dirPath.resolve("bnd.bnd");
                if (Files.exists(path, new LinkOption[0])) {
                    files.add(path.toFile());
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }
        });
        TreeMap<String, String> bundleVersionsMap = new TreeMap<String, String>();
        for (File file : files) {
            String bundleVersion;
            String content = FileUtil.read(file);
            String bundleSymbolicName = BNDSourceUtil.getDefinitionValue(content, "Bundle-SymbolicName");
            if (Validator.isNull(bundleSymbolicName)) continue;
            String path = SourceUtil.getAbsolutePath(file);
            if (path.endsWith("/portal-impl/bnd.bnd")) {
                bundleSymbolicName = "com.liferay.portal.impl";
            } else if (path.endsWith("/portal-kernel/bnd.bnd")) {
                bundleSymbolicName = "com.liferay.portal.kernel";
            } else if (path.endsWith("/portal-test-integration/bnd.bnd")) {
                bundleSymbolicName = "com.liferay.portal.test.integration";
            } else if (path.endsWith("/portal-test/bnd.bnd")) {
                bundleSymbolicName = "com.liferay.portal.test";
            } else if (path.endsWith("/portal-support-tomcat/bnd.bnd")) {
                bundleSymbolicName = "com.liferay.support.tomcat";
            } else if (path.endsWith("/util-bridges/bnd.bnd")) {
                bundleSymbolicName = "com.liferay.util.bridges";
            } else if (path.endsWith("/util-java/bnd.bnd")) {
                bundleSymbolicName = "com.liferay.util.java";
            } else if (path.endsWith("/util-slf4j/bnd.bnd")) {
                bundleSymbolicName = "com.liferay.util.slf4j";
            } else if (path.endsWith("/util-taglib/bnd.bnd")) {
                bundleSymbolicName = "com.liferay.util.taglib";
            }
            if (!bundleSymbolicName.startsWith("com.liferay.") || Validator.isNull(bundleVersion = BNDSourceUtil.getDefinitionValue(content, "Bundle-Version"))) continue;
            bundleVersionsMap.put(bundleSymbolicName, bundleVersion);
        }
        return bundleVersionsMap;
    }
}

