/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.java.parser;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.tools.java.parser.BaseJavaTerm;
import com.liferay.portal.tools.java.parser.JavaExpression;
import com.liferay.portal.tools.java.parser.JavaParameter;
import com.liferay.portal.tools.java.parser.JavaSimpleValue;
import com.liferay.portal.tools.java.parser.JavaType;
import java.util.List;
import java.util.Objects;

public class JavaSignature
extends BaseJavaTerm {
    private final List<JavaExpression> _exceptionJavaExpressions;
    private final List<JavaType> _genericJavaTypes;
    private String _indent;
    private final List<JavaParameter> _javaParameters;
    private final List<JavaSimpleValue> _modifiers;
    private final JavaSimpleValue _objectName;
    private final JavaType _returnJavaType;

    public JavaSignature(String objectName, List<JavaSimpleValue> modifiers, JavaType returnJavaType, List<JavaType> genericJavaTypes, List<JavaParameter> javaParameters, List<JavaExpression> exceptionJavaExpressions) {
        this._objectName = new JavaSimpleValue(objectName);
        this._modifiers = modifiers;
        this._returnJavaType = returnJavaType;
        this._genericJavaTypes = genericJavaTypes;
        this._javaParameters = javaParameters;
        this._exceptionJavaExpressions = exceptionJavaExpressions;
    }

    public String getIndent() {
        return this._indent;
    }

    public void setIndent(String indent) {
        this._indent = indent;
    }

    @Override
    public String toString(String indent, String prefix, String suffix, int maxLineLength) {
        StringBundler sb = new StringBundler();
        sb.append(indent);
        indent = "\t" + indent;
        if (!this._modifiers.isEmpty()) {
            this.appendSingleLine(sb, this._modifiers, " ", "", " ", maxLineLength);
        }
        if (this._genericJavaTypes != null) {
            indent = this.append(sb, this._genericJavaTypes, indent, "<", "> ", maxLineLength);
        }
        if (this._returnJavaType != null) {
            boolean newLine = false;
            if (this._genericJavaTypes != null) {
                newLine = true;
            }
            indent = this.append(sb, this._returnJavaType, indent, "", " ", maxLineLength, newLine);
        }
        if (this._javaParameters.isEmpty()) {
            if (this._exceptionJavaExpressions.isEmpty()) {
                if (this._genericJavaTypes == null && (this._returnJavaType == null || Objects.equals(this._returnJavaType.toString(), "void"))) {
                    this.appendSingleLine(sb, this._objectName, "", "()" + suffix, -1);
                } else {
                    this.append(sb, this._objectName, indent, "", "()" + suffix, maxLineLength);
                }
                return sb.toString();
            }
            if (!this.appendSingleLine(sb, this._objectName, "", "() ", maxLineLength)) {
                if (this._genericJavaTypes == null && (this._returnJavaType == null || Objects.equals(this._returnJavaType.toString(), "void"))) {
                    this.appendSingleLine(sb, this._objectName, "", "() ", -1);
                } else {
                    this.appendNewLine(sb, this._objectName, indent + "\t", "", "() ", maxLineLength);
                }
                this.appendNewLine(sb, this._exceptionJavaExpressions, indent, "throws ", suffix, maxLineLength);
                return sb.toString();
            }
            this.append(sb, this._exceptionJavaExpressions, indent, "throws ", suffix, maxLineLength);
            return sb.toString();
        }
        if (this._exceptionJavaExpressions.isEmpty()) {
            if (this.appendSingleLine(sb, this._objectName, "", "(", maxLineLength)) {
                this.append(sb, this._javaParameters, indent, "", ")" + suffix, maxLineLength);
                return sb.toString();
            }
            if (this._genericJavaTypes == null && this._returnJavaType == null) {
                this.appendSingleLine(sb, this._objectName, "", "(", -1);
                this.appendNewLine(sb, this._javaParameters, indent, "", ")" + suffix, maxLineLength);
            } else {
                this.appendNewLine(sb, this._objectName, indent, "", "(", maxLineLength);
                this.append(sb, this._javaParameters, indent + "\t", "", ")" + suffix, maxLineLength);
            }
            return sb.toString();
        }
        if (this.appendSingleLine(sb, this._objectName, "", "(", maxLineLength)) {
            if (this.appendSingleLine(sb, this._javaParameters, "", ")", maxLineLength)) {
                if (this.appendSingleLine(sb, this._exceptionJavaExpressions, " throws ", suffix, maxLineLength)) {
                    return sb.toString();
                }
                this.appendNewLine(sb, this._exceptionJavaExpressions, indent, "throws ", suffix, maxLineLength);
                return sb.toString();
            }
            this.appendNewLine(sb, this._javaParameters, indent + "\t", "", ")", maxLineLength);
            this.appendNewLine(sb, this._exceptionJavaExpressions, indent, "throws ", suffix, maxLineLength);
            return sb.toString();
        }
        if (this._genericJavaTypes == null && this._returnJavaType == null) {
            this.appendSingleLine(sb, this._objectName, " ", "(", -1);
        } else {
            this.appendNewLine(sb, this._objectName, indent + "\t", "", "(", maxLineLength);
            this.append(sb, this._javaParameters, indent + "\t\t", "", ")", maxLineLength);
            this.appendNewLine(sb, this._exceptionJavaExpressions, indent, "throws ", suffix, maxLineLength);
        }
        return sb.toString();
    }
}

