/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class JSONScriptsCheck
extends BaseFileCheck {
    private static final Map<String, String> _requiredScriptsMap = new HashMap<String, String>(){
        {
            this.put("liferay-npm-scripts", "csf,format");
        }
    };

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (absolutePath.endsWith("/package.json")) {
            this._checkMissingScripts(fileName, content);
        }
        return content;
    }

    private void _checkMissingScripts(String fileName, String content) {
        JSONObject jsonObject = new JSONObject(content);
        if (jsonObject.isNull("devDependencies")) {
            return;
        }
        JSONObject devDependenciesJSONObject = jsonObject.getJSONObject("devDependencies");
        for (Map.Entry<String, String> entry : _requiredScriptsMap.entrySet()) {
            String packageName = entry.getKey();
            if (devDependenciesJSONObject.isNull(packageName)) continue;
            for (String requiredScript : StringUtil.split(entry.getValue())) {
                if (jsonObject.isNull("scripts")) {
                    this.addMessage(fileName, this._getMessage(packageName, requiredScript));
                    continue;
                }
                JSONObject scriptsJSONObject = jsonObject.getJSONObject("scripts");
                if (scriptsJSONObject.isNull(requiredScript)) {
                    this.addMessage(fileName, this._getMessage(packageName, requiredScript));
                    continue;
                }
                String scriptValue = scriptsJSONObject.getString(requiredScript);
                if (scriptValue.startsWith(packageName + ' ')) continue;
                this.addMessage(fileName, this._getMessage(packageName, requiredScript));
            }
        }
    }

    private String _getMessage(String packageName, String requiredScript) {
        return StringBundler.concat("When using '" + packageName + "', a script for '", requiredScript, "' is required");
    }
}

