/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.YMLSourceUtil;
import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class YMLDefinitionOrderCheck
extends BaseFileCheck {
    private static final Pattern _incorrectIndentationPattern = Pattern.compile("^( *)[^ -].+(\n\\1- .+(\n\\1 .+)*)+", 8);
    private static final Map<String, Integer> _travisDefinitionKeyWeightMap = new HashMap<String, Integer>(){
        {
            this.put("after_deploy", 11);
            this.put("after_failure", 8);
            this.put("after_script", 12);
            this.put("after_success", 7);
            this.put("before_cache", 5);
            this.put("before_deploy", 9);
            this.put("before_install", 1);
            this.put("before_script", 3);
            this.put("cache", 6);
            this.put("deploy", 10);
            this.put("install", 2);
            this.put("script", 4);
        }
    };

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        content = this._fixIncorrectIndentation(content);
        return this._sortDefinitions(fileName, content, "");
    }

    private String _fixIncorrectIndentation(String content) {
        Matcher matcher = _incorrectIndentationPattern.matcher(content);
        while (matcher.find()) {
            content = StringUtil.replace(content, matcher.group(), StringUtil.replace(matcher.group(), "\n", "\n  "));
        }
        return content;
    }

    private String _sortDefinitions(String fileName, String content, String indent) {
        String newDefinition;
        String definition;
        String nestedDefinitionIndent;
        List<String> definitions = YMLSourceUtil.getDefinitions(content, indent);
        DefinitionComparator definitionComparator = new DefinitionComparator(fileName);
        if (definitions.size() == 1 && !(nestedDefinitionIndent = YMLSourceUtil.getNestedDefinitionIndent(definition = definitions.get(0))).equals("") && !(newDefinition = this._sortDefinitions(fileName, definition, nestedDefinitionIndent)).equals(definition)) {
            return StringUtil.replaceFirst(content, definition, newDefinition);
        }
        for (int i = 1; i < definitions.size(); ++i) {
            String newDefinition2;
            String definition2 = definitions.get(i);
            String trimmedDefinition = StringUtil.trimLeading(definition2);
            String previousDefinition = definitions.get(i - 1);
            String trimmedPreviousDefinition = StringUtil.trimLeading(previousDefinition);
            if (!trimmedDefinition.startsWith("#") && !trimmedPreviousDefinition.startsWith("#") && definitionComparator.compare(previousDefinition, definition2) > 0) {
                definition2 = StringUtil.trimTrailing(definition2);
                previousDefinition = StringUtil.trimTrailing(previousDefinition);
                content = StringUtil.replaceFirst(content, previousDefinition, definition2);
                return StringUtil.replaceLast(content, definition2, previousDefinition);
            }
            String nestedDefinitionIndent2 = YMLSourceUtil.getNestedDefinitionIndent(definition2);
            String definitionKey = definitionComparator._getDefinitionKey(definition2);
            if (!(nestedDefinitionIndent2.equals("") || _travisDefinitionKeyWeightMap.containsKey(definitionKey) || (newDefinition2 = this._sortDefinitions(fileName, definition2, nestedDefinitionIndent2)).equals(definition2))) {
                return StringUtil.replaceFirst(content, definition2, newDefinition2);
            }
            nestedDefinitionIndent2 = YMLSourceUtil.getNestedDefinitionIndent(previousDefinition);
            definitionKey = definitionComparator._getDefinitionKey(previousDefinition);
            if (nestedDefinitionIndent2.equals("") || _travisDefinitionKeyWeightMap.containsKey(definitionKey) || (newDefinition2 = this._sortDefinitions(fileName, previousDefinition, nestedDefinitionIndent2)).equals(previousDefinition)) continue;
            return StringUtil.replaceFirst(content, previousDefinition, newDefinition2);
        }
        return content;
    }

    private static class DefinitionComparator
    implements Comparator<String>,
    Serializable {
        private final Pattern _definitionKeyPattern = Pattern.compile(".*?:.*");
        private final String _fileName;

        public DefinitionComparator(String fileName) {
            this._fileName = fileName;
        }

        @Override
        public int compare(String definition1, String definition2) {
            String definitionKey1 = this._getDefinitionKey(definition1);
            String definitionKey2 = this._getDefinitionKey(definition2);
            if (this._fileName.endsWith("/.travis.yml")) {
                int weight1 = this._getTravisDefinitionKeyWeight(definitionKey1);
                int weight2 = this._getTravisDefinitionKeyWeight(definitionKey2);
                if (weight1 != -1 || weight2 != -1) {
                    return weight1 - weight2;
                }
            }
            if (definitionKey1.equals("- in: query") && definitionKey1.equals(definitionKey2)) {
                return this._sortSpecificDefinitions(definition1, definition2, "name");
            }
            return definitionKey1.compareTo(definitionKey2);
        }

        private String _getDefinitionKey(String definition) {
            Matcher matcher = this._definitionKeyPattern.matcher(definition);
            if (matcher.find()) {
                return StringUtil.trim(matcher.group());
            }
            return definition;
        }

        private int _getTravisDefinitionKeyWeight(String definitionKey) {
            String s = StringUtil.extractFirst(definitionKey, ':');
            if (_travisDefinitionKeyWeightMap.containsKey(s)) {
                return (Integer)_travisDefinitionKeyWeightMap.get(s);
            }
            return -1;
        }

        private int _sortSpecificDefinitions(String definition1, String definition2, String key) {
            Pattern pattern = Pattern.compile("^ *" + key + ": *(\\w*)(\n|\\Z)", 8);
            String value1 = "";
            Matcher matcher = pattern.matcher(definition1);
            if (matcher.find()) {
                value1 = matcher.group(1);
            }
            String value2 = "";
            matcher = pattern.matcher(definition2);
            if (matcher.find()) {
                value2 = matcher.group(1);
            }
            return value1.compareTo(value2);
        }
    }
}

