/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checkstyle.checks.StringConcatenationCheck;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.util.List;

public class PlusStatementCheck
extends StringConcatenationCheck {
    public int[] getDefaultTokens() {
        return new int[]{125};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        this._checkPlusOperator(detailAST);
    }

    private void _checkPlusOperator(DetailAST detailAST) {
        String trimmedLine2;
        if (detailAST.getChildCount() != 2) {
            return;
        }
        DetailAST firstChildDetailAST = detailAST.getFirstChild();
        String literalString1 = this._getLiteralString(firstChildDetailAST);
        if (literalString1 == null) {
            return;
        }
        DetailAST lastChildDetailAST = detailAST.getLastChild();
        String literalString2 = this._getLiteralString(lastChildDetailAST);
        if (literalString2 == null) {
            return;
        }
        if (firstChildDetailAST.getLineNo() == lastChildDetailAST.getLineNo()) {
            this.log(firstChildDetailAST, "literal.string.combine", new Object[]{literalString1, literalString2});
            return;
        }
        if (this._isRegexPattern(detailAST)) {
            return;
        }
        this.checkLiteralStringStartAndEndCharacter(literalString1, literalString2, detailAST.getLineNo());
        String line1 = this.getLine(lastChildDetailAST.getLineNo() - 2);
        String line2 = this.getLine(lastChildDetailAST.getLineNo() - 1);
        if (this._getLeadingTabCount(line1) == this._getLeadingTabCount(line2)) {
            return;
        }
        int lineLength1 = CommonUtil.lengthExpandedTabs((String)line1, (int)line1.length(), (int)this.getTabWidth());
        if (lineLength1 + (trimmedLine2 = StringUtil.trim(line2)).length() - 4 <= this.maxLineLength) {
            this.log(lastChildDetailAST, "literal.string.combine", new Object[]{literalString1, literalString2});
            return;
        }
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST.getType() == 125 && lineLength1 + literalString2.length() <= this.maxLineLength) {
            this.log(detailAST, "literal.string.combine", new Object[]{literalString1, literalString2});
            return;
        }
        int pos = this.getStringBreakPos(literalString1, literalString2, this.maxLineLength - lineLength1);
        if (pos != -1) {
            this.log(lastChildDetailAST, "literal.string.move", new Object[]{literalString2.substring(0, pos + 1)});
        }
    }

    private int _getLeadingTabCount(String line) {
        int leadingTabCount = 0;
        while (line.startsWith("\t")) {
            line = line.substring(1);
            ++leadingTabCount;
        }
        return leadingTabCount;
    }

    private String _getLiteralString(DetailAST detailAST) {
        DetailAST lastChildDetailAST;
        String literalString = null;
        if (detailAST.getType() == 139) {
            literalString = detailAST.getText();
        } else if (detailAST.getType() == 125 && detailAST.getChildCount() == 2 && (lastChildDetailAST = detailAST.getLastChild()).getType() == 139) {
            literalString = lastChildDetailAST.getText();
        }
        if (literalString != null) {
            return literalString.substring(1, literalString.length() - 1);
        }
        return null;
    }

    private boolean _isRegexPattern(DetailAST detailAST) {
        for (DetailAST parentDetailAST = detailAST.getParent(); parentDetailAST != null; parentDetailAST = parentDetailAST.getParent()) {
            if (parentDetailAST.getType() != 27) {
                continue;
            }
            DetailAST firstChildDetailAST = parentDetailAST.getFirstChild();
            if (firstChildDetailAST.getType() != 59) {
                return false;
            }
            List<DetailAST> nameDetailASTList = DetailASTUtil.getAllChildTokens(firstChildDetailAST, false, 58);
            if (nameDetailASTList.size() != 2) {
                return false;
            }
            DetailAST classNameDetailAST = nameDetailASTList.get(0);
            DetailAST methodNameDetailAST = nameDetailASTList.get(1);
            String methodCallClassName = classNameDetailAST.getText();
            String methodCallMethodName = methodNameDetailAST.getText();
            return methodCallMethodName.equals("matches") || methodCallClassName.equals("Pattern") && methodCallMethodName.equals("compile");
        }
        return false;
    }
}

