/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.api;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.ArrayList;
import java.util.List;

public final class FullIdent {
    private final List<String> elements = new ArrayList<String>();
    private int lineNo;
    private int columnNo;

    private FullIdent() {
    }

    public static FullIdent createFullIdent(DetailAST ast) {
        FullIdent ident = new FullIdent();
        FullIdent.extractFullIdent(ident, ast);
        return ident;
    }

    public static FullIdent createFullIdentBelow(DetailAST ast) {
        return FullIdent.createFullIdent(ast.getFirstChild());
    }

    public String getText() {
        return String.join((CharSequence)"", this.elements);
    }

    public int getLineNo() {
        return this.lineNo;
    }

    public int getColumnNo() {
        return this.columnNo;
    }

    public String toString() {
        return String.join((CharSequence)"", this.elements) + "[" + this.lineNo + "x" + this.columnNo + "]";
    }

    private static void extractFullIdent(FullIdent full, DetailAST ast) {
        if (ast != null) {
            if (ast.getType() == 59) {
                FullIdent.extractFullIdent(full, ast.getFirstChild());
                full.append(".");
                FullIdent.extractFullIdent(full, ast.getFirstChild().getNextSibling());
            } else if (ast.getType() == 17) {
                FullIdent.extractFullIdent(full, ast.getFirstChild());
                full.append("[]");
            } else {
                full.append(ast);
            }
        }
    }

    private void append(String text) {
        this.elements.add(text);
    }

    private void append(DetailAST ast) {
        this.elements.add(ast.getText());
        if (this.lineNo == 0) {
            this.lineNo = ast.getLineNo();
        } else if (ast.getLineNo() > 0) {
            this.lineNo = Math.min(this.lineNo, ast.getLineNo());
        }
        if (this.columnNo == 0) {
            this.columnNo = ast.getColumnNo();
        } else if (ast.getColumnNo() > 0) {
            this.columnNo = Math.min(this.columnNo, ast.getColumnNo());
        }
    }
}

