/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BNDSettings {
    private static final Pattern _contentDirPattern = Pattern.compile("\\scontent=(.*?)(,\\\\|\n|$)");
    private static final Pattern _releaseVersionPattern = Pattern.compile("Bundle-Version: (.*)(\n|\\Z)");
    private final String _content;
    private final String _fileName;
    private Properties _languageProperties;
    private String _releaseVersion;

    public BNDSettings(String fileName, String content) {
        this._fileName = fileName;
        this._content = content;
    }

    public String getContent() {
        return this._content;
    }

    public String getFileLocation() {
        int pos = this._fileName.lastIndexOf(47);
        return this._fileName.substring(0, pos + 1);
    }

    public String getFileName() {
        return this._fileName;
    }

    public Properties getLanguageProperties() throws IOException {
        File file;
        if (this._languageProperties != null) {
            return this._languageProperties;
        }
        if (this._content.matches("[\\s\\S]*Provide-Capability:[\\s\\S]*liferay\\.resource\\.bundle[\\s\\S]*")) {
            return null;
        }
        Properties languageProperties = new Properties();
        Matcher matcher = _contentDirPattern.matcher(this._content);
        if (matcher.find() && (file = new File(this.getFileLocation() + matcher.group(1) + "/Language.properties")).exists()) {
            languageProperties.load(new FileInputStream(file));
        }
        this._languageProperties = languageProperties;
        return this._languageProperties;
    }

    public String getReleaseVersion() {
        if (this._releaseVersion != null) {
            return this._releaseVersion;
        }
        Matcher matcher = _releaseVersionPattern.matcher(this._content);
        if (!matcher.find()) {
            return null;
        }
        this._releaseVersion = matcher.group(1);
        return this._releaseVersion;
    }
}

