/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.SourceFormatterExcludes;
import com.liferay.source.formatter.checks.util.SourceUtil;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.util.SourceFormatterUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class TaglibUtil {
    public static List<String> getExtendedTagFileNames(JavaClass javaClass, String absolutePath, String utilTaglibSrcDirName) {
        ArrayList<String> extendedTagFilesNames = new ArrayList<String>();
        for (String extendedClassName : javaClass.getExtendedClassNames(true)) {
            int pos;
            StringBundler sb = new StringBundler(5);
            if (extendedClassName.startsWith("com.liferay.taglib")) {
                sb.append(utilTaglibSrcDirName);
            } else if (extendedClassName.startsWith(javaClass.getPackageName())) {
                pos = absolutePath.lastIndexOf(47);
                sb.append(absolutePath.substring(0, pos + 1));
                extendedClassName = StringUtil.removeSubstring(extendedClassName, javaClass.getPackageName() + ".");
            } else {
                if (!extendedClassName.startsWith("com.liferay.frontend.taglib.soy.") || (pos = absolutePath.indexOf("/modules/apps/")) == -1) continue;
                sb.append(absolutePath.substring(0, pos));
                sb.append("/modules/apps/frontend-taglib/frontend-taglib-soy");
                sb.append("/src/main/java/");
            }
            sb.append(StringUtil.replace(extendedClassName, '.', '/'));
            sb.append(".java");
            extendedTagFilesNames.add(sb.toString());
        }
        return extendedTagFilesNames;
    }

    public static List<String> getTLDFileNames(String baseDirName, List<String> allFileNames, SourceFormatterExcludes sourceFormatterExcludes, boolean portalSource) throws IOException {
        String[] excludes = new String[]{"**/dependencies/**", "**/util-taglib/**", "**/portal-web/**"};
        List<String> tldFileNames = SourceFormatterUtil.filterFileNames(allFileNames, excludes, new String[]{"**/*.tld"}, sourceFormatterExcludes, true);
        if (!portalSource) {
            return tldFileNames;
        }
        String tldDirLocation = "portal-web/docroot/WEB-INF/tld/";
        for (int i = 0; i < 6; ++i) {
            File file = new File(baseDirName + tldDirLocation);
            if (file.exists()) {
                tldFileNames.addAll(SourceFormatterUtil.scanForFiles(baseDirName + tldDirLocation, new String[0], new String[]{"**/*.tld"}, sourceFormatterExcludes, true));
                break;
            }
            tldDirLocation = "../" + tldDirLocation;
        }
        return tldFileNames;
    }

    public static String getUtilTaglibSrcDirName(String baseDirName) {
        File utilTaglibDir = SourceFormatterUtil.getFile(baseDirName, "util-taglib/src", 7);
        if (utilTaglibDir == null) {
            return "";
        }
        return SourceUtil.getAbsolutePath(utilTaglibDir) + "/";
    }
}

