/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.language;

import aQute.bnd.annotation.ProviderType;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.language.LanguageWrapper;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Supplier;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@ProviderType
public class LanguageUtil {
    private static Language _language;

    public static String format(HttpServletRequest request, String pattern, LanguageWrapper argument) {
        return LanguageUtil.getLanguage().format(request, pattern, argument);
    }

    public static String format(HttpServletRequest request, String pattern, LanguageWrapper argument, boolean translateArguments) {
        return LanguageUtil.getLanguage().format(request, pattern, argument, translateArguments);
    }

    public static String format(HttpServletRequest request, String pattern, LanguageWrapper[] arguments) {
        return LanguageUtil.getLanguage().format(request, pattern, arguments);
    }

    public static String format(HttpServletRequest request, String pattern, LanguageWrapper[] arguments, boolean translateArguments) {
        return LanguageUtil.getLanguage().format(request, pattern, arguments, translateArguments);
    }

    public static String format(HttpServletRequest request, String pattern, Object argument) {
        return LanguageUtil.getLanguage().format(request, pattern, argument);
    }

    public static String format(HttpServletRequest request, String pattern, Object argument, boolean translateArguments) {
        return LanguageUtil.getLanguage().format(request, pattern, argument, translateArguments);
    }

    public static String format(HttpServletRequest request, String pattern, Object[] arguments) {
        return LanguageUtil.getLanguage().format(request, pattern, arguments);
    }

    public static String format(HttpServletRequest request, String pattern, Object[] arguments, boolean translateArguments) {
        return LanguageUtil.getLanguage().format(request, pattern, arguments, translateArguments);
    }

    public static String format(Locale locale, String pattern, List<Object> arguments) {
        return LanguageUtil.getLanguage().format(locale, pattern, arguments);
    }

    public static String format(Locale locale, String pattern, Object argument) {
        return LanguageUtil.getLanguage().format(locale, pattern, argument);
    }

    public static String format(Locale locale, String pattern, Object argument, boolean translateArguments) {
        return LanguageUtil.getLanguage().format(locale, pattern, argument, translateArguments);
    }

    public static String format(Locale locale, String pattern, Object[] arguments) {
        return LanguageUtil.getLanguage().format(locale, pattern, arguments);
    }

    public static String format(Locale locale, String pattern, Object[] arguments, boolean translateArguments) {
        return LanguageUtil.getLanguage().format(locale, pattern, arguments, translateArguments);
    }

    public static String format(ResourceBundle resourceBundle, String pattern, Object argument) {
        return LanguageUtil.getLanguage().format(resourceBundle, pattern, argument);
    }

    public static String format(ResourceBundle resourceBundle, String pattern, Object argument, boolean translateArguments) {
        return LanguageUtil.getLanguage().format(resourceBundle, pattern, argument, translateArguments);
    }

    public static String format(ResourceBundle resourceBundle, String pattern, Object[] arguments) {
        return LanguageUtil.getLanguage().format(resourceBundle, pattern, arguments);
    }

    public static String format(ResourceBundle resourceBundle, String pattern, Object[] arguments, boolean translateArguments) {
        return LanguageUtil.getLanguage().format(resourceBundle, pattern, arguments, translateArguments);
    }

    public static String get(HttpServletRequest request, ResourceBundle resourceBundle, String key) {
        return LanguageUtil.getLanguage().get(request, resourceBundle, key);
    }

    public static String get(HttpServletRequest request, ResourceBundle resourceBundle, String key, String defaultValue) {
        return LanguageUtil.getLanguage().get(request, resourceBundle, key, defaultValue);
    }

    public static String get(HttpServletRequest request, String key) {
        return LanguageUtil.getLanguage().get(request, key);
    }

    public static String get(HttpServletRequest request, String key, String defaultValue) {
        return LanguageUtil.getLanguage().get(request, key, defaultValue);
    }

    public static String get(Locale locale, String key) {
        return LanguageUtil.getLanguage().get(locale, key);
    }

    public static String get(Locale locale, String key, String defaultValue) {
        return LanguageUtil.getLanguage().get(locale, key, defaultValue);
    }

    public static String get(ResourceBundle resourceBundle, String key) {
        return LanguageUtil.getLanguage().get(resourceBundle, key);
    }

    public static String get(ResourceBundle resourceBundle, String key, String defaultValue) {
        return LanguageUtil.getLanguage().get(resourceBundle, key, defaultValue);
    }

    public static Set<Locale> getAvailableLocales() {
        return LanguageUtil.getLanguage().getAvailableLocales();
    }

    public static Set<Locale> getAvailableLocales(long groupId) {
        return LanguageUtil.getLanguage().getAvailableLocales(groupId);
    }

    public static String getBCP47LanguageId(HttpServletRequest request) {
        return LanguageUtil.getLanguage().getBCP47LanguageId(request);
    }

    public static String getBCP47LanguageId(Locale locale) {
        return LanguageUtil.getLanguage().getBCP47LanguageId(locale);
    }

    public static String getBCP47LanguageId(PortletRequest portletRequest) {
        return LanguageUtil.getLanguage().getBCP47LanguageId(portletRequest);
    }

    public static Set<Locale> getCompanyAvailableLocales(long companyId) {
        return LanguageUtil.getLanguage().getCompanyAvailableLocales(companyId);
    }

    public static Language getLanguage() {
        return _language;
    }

    public static String getLanguageId(HttpServletRequest request) {
        return LanguageUtil.getLanguage().getLanguageId(request);
    }

    public static String getLanguageId(Locale locale) {
        return LanguageUtil.getLanguage().getLanguageId(locale);
    }

    public static String getLanguageId(PortletRequest portletRequest) {
        return LanguageUtil.getLanguage().getLanguageId(portletRequest);
    }

    public static long getLastModified() {
        return LanguageUtil.getLanguage().getLastModified();
    }

    public static Locale getLocale(long groupId, String languageCode) {
        return LanguageUtil.getLanguage().getLocale(groupId, languageCode);
    }

    public static Locale getLocale(String languageCode) {
        return LanguageUtil.getLanguage().getLocale(languageCode);
    }

    public static ResourceBundleLoader getPortalResourceBundleLoader() {
        return LanguageUtil.getLanguage().getPortalResourceBundleLoader();
    }

    public static Set<Locale> getSupportedLocales() {
        return LanguageUtil.getLanguage().getSupportedLocales();
    }

    public static String getTimeDescription(HttpServletRequest request, long milliseconds) {
        return LanguageUtil.getLanguage().getTimeDescription(request, milliseconds);
    }

    public static String getTimeDescription(HttpServletRequest request, long milliseconds, boolean approximate) {
        return LanguageUtil.getLanguage().getTimeDescription(request, milliseconds, approximate);
    }

    public static String getTimeDescription(HttpServletRequest request, Long milliseconds) {
        return LanguageUtil.getLanguage().getTimeDescription(request, milliseconds);
    }

    public static String getTimeDescription(Locale locale, long milliseconds) {
        return LanguageUtil.getLanguage().getTimeDescription(locale, milliseconds);
    }

    public static String getTimeDescription(Locale locale, long milliseconds, boolean approximate) {
        return LanguageUtil.getLanguage().getTimeDescription(locale, milliseconds, approximate);
    }

    public static String getTimeDescription(Locale locale, Long milliseconds) {
        return LanguageUtil.getLanguage().getTimeDescription(locale, milliseconds);
    }

    public static void init() {
        LanguageUtil.getLanguage().init();
    }

    public static boolean isAvailableLanguageCode(String languageCode) {
        return LanguageUtil.getLanguage().isAvailableLanguageCode(languageCode);
    }

    public static boolean isAvailableLocale(Locale locale) {
        return LanguageUtil.getLanguage().isAvailableLocale(locale);
    }

    public static boolean isAvailableLocale(long groupId, Locale locale) {
        return LanguageUtil.getLanguage().isAvailableLocale(groupId, locale);
    }

    public static boolean isAvailableLocale(long groupId, String languageId) {
        return LanguageUtil.getLanguage().isAvailableLocale(groupId, languageId);
    }

    public static boolean isAvailableLocale(String languageId) {
        return LanguageUtil.getLanguage().isAvailableLocale(languageId);
    }

    public static boolean isBetaLocale(Locale locale) {
        return LanguageUtil.getLanguage().isBetaLocale(locale);
    }

    public static boolean isDuplicateLanguageCode(String languageCode) {
        return LanguageUtil.getLanguage().isDuplicateLanguageCode(languageCode);
    }

    public static boolean isInheritLocales(long groupId) throws PortalException {
        return LanguageUtil.getLanguage().isInheritLocales(groupId);
    }

    public static boolean isSameLanguage(Locale locale1, Locale locale2) {
        return LanguageUtil.getLanguage().isSameLanguage(locale1, locale2);
    }

    public static boolean isValidLanguageKey(Locale locale, String key) {
        String value = LanguageUtil.getLanguage().get(locale, key, "");
        return Validator.isNotNull(value);
    }

    @Deprecated
    public static String process(ResourceBundle resourceBundle, Locale locale, String content) {
        return LanguageUtil.getLanguage().process(resourceBundle, locale, content);
    }

    public static String process(Supplier<ResourceBundle> resourceBundleSupplier, Locale locale, String content) {
        return LanguageUtil.getLanguage().process(resourceBundleSupplier, locale, content);
    }

    public static void resetAvailableGroupLocales(long groupId) {
        LanguageUtil.getLanguage().resetAvailableGroupLocales(groupId);
    }

    public static void resetAvailableLocales(long companyId) {
        LanguageUtil.getLanguage().resetAvailableLocales(companyId);
    }

    public static void updateCookie(HttpServletRequest request, HttpServletResponse response, Locale locale) {
        LanguageUtil.getLanguage().updateCookie(request, response, locale);
    }

    public void setLanguage(Language language) {
        _language = language;
    }
}

