/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.BaseSourceProcessor;
import com.liferay.source.formatter.checks.SourceCheck;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class YMLSourceProcessor
extends BaseSourceProcessor {
    private static final String[] _INCLUDES = new String[]{"**/*.yaml", "**/*.yml"};
    private static final Pattern _sequencesAndMappingsPattern1 = Pattern.compile("^( *)[^ -].+(\n\\1-(\n\\1 .+)*)+", 8);
    private static final Pattern _sequencesAndMappingsPattern2 = Pattern.compile("(^( *)-)(?: )(.+(\n|\\Z))", 8);

    @Override
    protected List<String> doGetFileNames() throws IOException {
        return this.getFileNames(new String[0], this.getIncludes());
    }

    @Override
    protected String[] doGetIncludes() {
        return _INCLUDES;
    }

    @Override
    protected File format(File file, String fileName, String absolutePath, String content) throws Exception {
        HashSet<String> modifiedContents = new HashSet<String>();
        TreeSet<String> modifiedMessages = new TreeSet<String>();
        String newContent = this._preProcess(content);
        newContent = this.format(file, fileName, absolutePath, newContent, content, new ArrayList<SourceCheck>(this.getSourceChecks()), modifiedContents, modifiedMessages, 0);
        newContent = this._postProcess(newContent);
        return this.processFormattedFile(file, fileName, content, newContent, modifiedMessages);
    }

    private String _fixIncorrectIndentation(String content) {
        Matcher matcher = _sequencesAndMappingsPattern1.matcher(content);
        while (matcher.find()) {
            String s = matcher.group();
            String[] lines = s.split("\n");
            StringBundler sb = new StringBundler();
            for (int i = 1; i < lines.length; ++i) {
                sb.append("\n");
                sb.append("  ");
                sb.append(lines[i]);
            }
            content = StringUtil.replaceFirst(content, matcher.group(), lines[0] + this._fixIncorrectIndentation(sb.toString()));
        }
        return content;
    }

    private String _postProcess(String content) {
        return content.replaceAll("( +-)\n +(.*)", "$1 $2");
    }

    private String _preProcess(String content) {
        Matcher matcher = _sequencesAndMappingsPattern2.matcher(content);
        while (matcher.find()) {
            content = StringUtil.replaceFirst(content, matcher.group(), StringBundler.concat(matcher.group(1), "\n", matcher.group(2), "  ", matcher.group(3)));
        }
        return this._fixIncorrectIndentation(content);
    }
}

