/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class JSONPackageJSONCheck
extends BaseFileCheck {
    private static final Map<String, String> _requiredScriptsMap = new HashMap<String, String>(){
        {
            this.put("build", "liferay-npm-scripts build.*");
            this.put("checkFormat", "liferay-npm-scripts lint");
            this.put("format", "liferay-npm-scripts format");
        }
    };

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (absolutePath.endsWith("/package.json") && absolutePath.contains("/modules/apps/")) {
            JSONObject jsonObject = new JSONObject(content);
            this._checkIncorrectEntry(fileName, jsonObject, "devDependencies");
            this._checkRequiredScripts(fileName, jsonObject);
        }
        return content;
    }

    private void _checkIncorrectEntry(String fileName, JSONObject jsonObject, String entryName) {
        if (!jsonObject.isNull(entryName)) {
            this.addMessage(fileName, "Entry '" + entryName + "' is not allowed");
        }
    }

    private void _checkRequiredScripts(String fileName, JSONObject jsonObject) {
        if (jsonObject.isNull("scripts")) {
            this.addMessage(fileName, "Missing entry 'scripts'");
            return;
        }
        JSONObject scriptsJSONObject = jsonObject.getJSONObject("scripts");
        for (Map.Entry<String, String> entry : _requiredScriptsMap.entrySet()) {
            String entryName = entry.getKey();
            if (scriptsJSONObject.isNull(entryName)) {
                this.addMessage(fileName, "Missing entry '" + entryName + "' in 'scripts'");
                continue;
            }
            String value = scriptsJSONObject.getString(entryName);
            if (value.matches(entry.getValue())) continue;
            this.addMessage(fileName, StringBundler.concat("Value '", value, "' for entry '", entryName, "' does not match expected value '", entry.getValue(), "'"));
        }
    }
}

