/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checks.JavaAnnotationsCheck;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaTerm;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaAnnotationDefaultAttributeCheck
extends JavaAnnotationsCheck {
    private static final Pattern _valueAttributePattern = Pattern.compile("^(\\s*@[\\w.]+\\(\\s*)(value = )");

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) throws IOException {
        return this.formatAnnotations(fileName, (JavaClass)javaTerm);
    }

    @Override
    protected String formatAnnotation(String fileName, JavaClass javaClass, String annotation, String indent) {
        annotation = this._formatDefaultAttribute(annotation);
        annotation = this._formatDefaultValue(annotation, javaClass, "aQute.bnd.annotation.metatype", "Meta.AD", "cardinality", "0");
        annotation = this._formatDefaultValue(annotation, javaClass, "aQute.bnd.annotation.metatype", "Meta.AD", "required", "true");
        annotation = this._formatDefaultValue(annotation, javaClass, "aQute.bnd.annotation.metatype", "Meta.OCD", "factory", "false");
        annotation = this._formatDefaultValue(annotation, javaClass, "org.springframework.web.bind.annotation", "DeleteMapping");
        annotation = this._formatDefaultValue(annotation, javaClass, "org.springframework.web.bind.annotation", "GetMapping");
        annotation = this._formatDefaultValue(annotation, javaClass, "org.springframework.web.bind.annotation", "PatchMapping");
        annotation = this._formatDefaultValue(annotation, javaClass, "org.springframework.web.bind.annotation", "PostMapping");
        annotation = this._formatDefaultValue(annotation, javaClass, "org.springframework.web.bind.annotation", "PutMapping");
        return annotation;
    }

    private String _formatDefaultAttribute(String annotation) {
        Matcher matcher = _valueAttributePattern.matcher(annotation);
        if (!matcher.find()) {
            return annotation;
        }
        int x = matcher.end();
        while ((x = annotation.indexOf(44, x + 1)) != -1) {
            if (ToolsUtil.isInsideQuotes(annotation, x) || this.getLevel(annotation.substring(matcher.end(), x), "{", "}") != 0) continue;
            return annotation;
        }
        return matcher.replaceFirst("$1");
    }

    private String _formatDefaultValue(String annotation, JavaClass javaClass, String packageName, String annotationName) {
        return this._formatDefaultValue(annotation, javaClass, packageName, annotationName, null, "\"\"");
    }

    private String _formatDefaultValue(String annotation, JavaClass javaClass, String packageName, String annotationName, String attributeName, String defaultAttributeValue) {
        List<String> imports = javaClass.getImports();
        String importName = null;
        int pos = annotationName.indexOf(46);
        importName = pos == -1 ? packageName + "." + annotationName : packageName + "." + annotationName.substring(0, pos);
        if (!imports.contains(importName)) {
            return annotation;
        }
        if (attributeName == null) {
            Pattern pattern = Pattern.compile(StringBundler.concat("(@", annotationName, ")\\(\\s*", defaultAttributeValue, "\\s*\\)"));
            Matcher matcher = pattern.matcher(annotation);
            if (matcher.find()) {
                return matcher.replaceFirst("$1");
            }
            return annotation;
        }
        Pattern pattern = Pattern.compile(StringBundler.concat("(\\(|,)\\s*", attributeName, " = ", defaultAttributeValue, "\\s*(\\)|,)"));
        Matcher matcher = pattern.matcher(annotation);
        if (!matcher.find()) {
            return annotation;
        }
        if (Objects.equals(matcher.group(1), ",")) {
            return matcher.replaceFirst("$2");
        }
        if (Objects.equals(matcher.group(2), ",")) {
            return matcher.replaceFirst("$1");
        }
        return matcher.replaceFirst("");
    }
}

