/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.WhitespaceCheck;
import com.liferay.source.formatter.checks.util.YMLSourceUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class YMLWhitespaceCheck
extends WhitespaceCheck {
    private static final Pattern _mappingEntryPattern = Pattern.compile("^( *)- *?(\n|\\Z)((\\1 +.+)(\n|\\Z)+)+", 8);

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        content = StringUtil.replace(content, '\t', "    ");
        content = this._formatDefinitions(fileName, content, "", 0);
        content = this._formatSequencesAndMappings(content);
        return super.doProcess(fileName, absolutePath, content);
    }

    private String _formatDefinition(String fileName, String definition, String indent, int level, boolean hasNestedDefinitions) {
        String expectedIndent = "";
        for (int j = 0; j < level; ++j) {
            expectedIndent = expectedIndent + "    ";
        }
        String newDefinition = definition;
        if (!expectedIndent.equals(indent)) {
            newDefinition = expectedIndent + StringUtil.trimLeading(definition);
        }
        if (hasNestedDefinitions) {
            return newDefinition;
        }
        String[] lines = StringUtil.splitLines(newDefinition);
        if (lines.length <= 1) {
            return newDefinition;
        }
        String firstLine = lines[1];
        String newNestedContent = "";
        String oldNestedContent = "";
        String nestedIndent = firstLine.replaceAll("^(\\s+).+", "$1");
        if (nestedIndent.equals(firstLine)) {
            nestedIndent = "";
        }
        for (int j = 1; j < lines.length; ++j) {
            String line = lines[j];
            if (j > 1) {
                newNestedContent = newNestedContent + "\n";
                oldNestedContent = oldNestedContent + "\n";
            }
            newNestedContent = newNestedContent + line;
            oldNestedContent = oldNestedContent + line;
            if (Validator.isNull(line)) continue;
            String curIndent = line.replaceAll("^(\\s+).+", "$1");
            if (curIndent.equals(line)) {
                curIndent = "";
            }
            if (!curIndent.equals(nestedIndent)) continue;
            String trimmedLine = StringUtil.trimLeading(line);
            newNestedContent = StringUtil.replaceLast(newNestedContent, line, expectedIndent + "    " + trimmedLine);
        }
        if (!newNestedContent.equals(oldNestedContent)) {
            if (!this._hasMapInsideList(lines)) {
                newDefinition = StringUtil.replaceFirst(newDefinition, oldNestedContent, newNestedContent);
            } else {
                String message = StringBundler.concat("Incorrect whitespace, expected '", expectedIndent + "    ", "'\n", oldNestedContent);
                this.addMessage(fileName, message);
            }
        }
        return newDefinition;
    }

    private String _formatDefinitions(String fileName, String content, String indent, int level) {
        List<String> definitions = YMLSourceUtil.getDefinitions(content, indent);
        String[] lines = content.split("\n");
        int pos = lines[0].length();
        for (String definition : definitions) {
            String newDefinition;
            String nestedDefinitionIndent = YMLSourceUtil.getNestedDefinitionIndent(definition);
            List<Object> nestedDefinitions = Collections.emptyList();
            if (!nestedDefinitionIndent.equals("")) {
                nestedDefinitions = YMLSourceUtil.getDefinitions(definition, nestedDefinitionIndent);
                newDefinition = this._formatDefinitions(fileName, definition, nestedDefinitionIndent, level + 1);
                if (!newDefinition.equals(definition)) {
                    content = StringUtil.replaceFirst(content, definition, newDefinition, 0);
                    definition = newDefinition;
                }
            }
            if (!(newDefinition = this._formatDefinition(fileName, definition, indent, level, !nestedDefinitions.isEmpty())).equals(definition)) {
                content = StringUtil.replaceFirst(content, definition, newDefinition, pos);
            }
            pos += newDefinition.length();
        }
        return content;
    }

    private String _formatSequencesAndMappings(String content) {
        Matcher matcher = _mappingEntryPattern.matcher(content);
        while (matcher.find()) {
            String s = matcher.group();
            String[] lines = s.split("\n");
            if (lines.length <= 1 || StringUtil.startsWith(lines[0].trim(), "- '")) continue;
            StringBundler sb = new StringBundler();
            for (int i = 1; i < lines.length; ++i) {
                sb.append("\n");
                if (!Validator.isNotNull(lines[i])) continue;
                sb.append(lines[i].substring(2));
            }
            sb.append("\n");
            String newContent = this._formatSequencesAndMappings(sb.toString());
            if (s.endsWith("\n\n")) {
                newContent = newContent + "\n";
            }
            content = StringUtil.replaceFirst(content, matcher.group(), lines[0] + newContent);
        }
        return content;
    }

    private boolean _hasMapInsideList(String[] lines) {
        if (lines.length <= 1) {
            return false;
        }
        String trimmedFirstLine = StringUtil.trimLeading(lines[1]);
        if (!trimmedFirstLine.startsWith("-")) {
            return false;
        }
        for (int j = 1; j < lines.length; ++j) {
            String trimmedLine = StringUtil.trimLeading(lines[j]);
            if (!trimmedLine.matches("\\w+:.*")) continue;
            return true;
        }
        return false;
    }
}

