/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.java.parser;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.portal.tools.java.parser.JavaExpression;

public class JavaSimpleValue
extends JavaExpression {
    private final String _name;

    public JavaSimpleValue(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    @Override
    protected String getString(String indent, String prefix, String suffix, int maxLineLength, boolean forceLineBreak) {
        String firstLine;
        String s = StringBundler.concat(indent, prefix, this._name, suffix);
        if (maxLineLength == -1 || this.getLineLength(s) <= maxLineLength) {
            return s;
        }
        int x = this._name.length() + 1;
        do {
            if ((x = this._name.lastIndexOf(".", x - 1)) != -1) continue;
            return StringBundler.concat(indent, prefix, this._name, suffix);
        } while (ToolsUtil.isInsideQuotes(this._name, x) || this.getLineLength(firstLine = StringBundler.concat(indent, prefix, this._name.substring(0, x + 1))) > maxLineLength);
        String secondLineIndent = "\t" + indent;
        String trimmedFirstLine = StringUtil.trim(firstLine);
        if (trimmedFirstLine.startsWith("catch (")) {
            secondLineIndent = secondLineIndent + "\t\t";
        } else if (trimmedFirstLine.startsWith("else if (")) {
            secondLineIndent = secondLineIndent + "\t\t";
        } else if (trimmedFirstLine.startsWith("for (") && !trimmedFirstLine.endsWith(";")) {
            secondLineIndent = secondLineIndent + "\t";
        } else if (trimmedFirstLine.startsWith("if (")) {
            secondLineIndent = secondLineIndent + "\t";
        } else if (trimmedFirstLine.startsWith("try (") && !trimmedFirstLine.endsWith(";")) {
            secondLineIndent = secondLineIndent + "\t";
        } else if (trimmedFirstLine.startsWith("while (")) {
            secondLineIndent = secondLineIndent + "\t\t";
        }
        return StringBundler.concat(firstLine, "\n", secondLineIndent, this._name.substring(x + 1), suffix);
    }
}

