/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.source.formatter.BNDSettings;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.JavaSourceUtil;
import java.io.IOException;
import java.util.List;

public class JavaInternalPackageCheck
extends BaseFileCheck {
    @Override
    public boolean isPortalCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        if (!absolutePath.contains("/modules/apps/") || !absolutePath.contains("-web/src/") || absolutePath.contains("/test/") || absolutePath.contains("/testIntegration/")) {
            return content;
        }
        String packageName = JavaSourceUtil.getPackageName(content);
        if (packageName.contains(".internal.") || packageName.endsWith(".internal")) {
            return content;
        }
        BNDSettings bndSettings = this.getBNDSettings(fileName);
        if (bndSettings == null) {
            return content;
        }
        List<String> exportPackageNames = bndSettings.getExportPackageNames();
        if (!exportPackageNames.contains(packageName)) {
            this.addMessage(fileName, "Classes that are not exported should be in 'internal' package");
        }
        return content;
    }
}

