/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.JavaSourceUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaModuleServiceReferenceCheck
extends BaseFileCheck {
    private static final Pattern _serviceReferencePattern = Pattern.compile("@ServiceReference\\(\\s*type = ([\\w.]+)\\.class\\)\n");

    @Override
    public boolean isModulesCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        String packageName = JavaSourceUtil.getPackageName(content);
        int pos = packageName.indexOf(".service.");
        if (pos == -1) {
            return content;
        }
        String servicePackageName = packageName.substring(0, pos + 8);
        this._checkServiceReferences(fileName, content, packageName, servicePackageName);
        return content;
    }

    private void _checkServiceReferences(String fileName, String content, String packageName, String servicePackageName) {
        Matcher matcher = _serviceReferencePattern.matcher(content);
        while (matcher.find()) {
            String className = this._getFullClassName(content, matcher.group(1), packageName);
            if (!className.startsWith(servicePackageName)) continue;
            this.addMessage(fileName, "Use @BeanReference instead of @ServiceReference", this.getLineNumber(content, matcher.start()));
        }
    }

    private String _getFullClassName(String content, String className, String packageName) {
        if (className.contains(".")) {
            return className;
        }
        Pattern pattern = Pattern.compile("import (.*" + className + ");");
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return packageName + "." + className;
    }
}

