/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.io.IOException;

public class PoshiIndentationCheck
extends BaseFileCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            int level = 0;
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                sb.append(this._fixIndentation(line, level));
                sb.append("\n");
                level += this.getLevel(line, new String[]{"(", "{"}, new String[]{")", "}"});
            }
        }
        if (sb.index() > 0) {
            sb.setIndex(sb.index() - 1);
        }
        return sb.toString();
    }

    private String _fixIndentation(String line, int level) {
        String trimmedLine = StringUtil.trim(line);
        if (Validator.isNull(trimmedLine)) {
            return "";
        }
        StringBundler sb = new StringBundler();
        for (int i = 0; i < level && (i != level - 1 || !trimmedLine.startsWith(")") && !trimmedLine.startsWith("}")); ++i) {
            sb.append('\t');
        }
        sb.append(trimmedLine);
        return sb.toString();
    }
}

