/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.List;

public class FrameworkBundleCheck
extends BaseCheck {
    private static final String _MSG_USE_BUNDLE_GET_HEADERS = "bundle.get.headers.use";

    public int[] getDefaultTokens() {
        return new int[]{14};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST != null) {
            return;
        }
        List<String> importNames = DetailASTUtil.getImportNames(detailAST);
        if (!importNames.contains("org.osgi.framework.Bundle")) {
            return;
        }
        List<DetailAST> detailASTList = DetailASTUtil.getAllChildTokens(detailAST, true, 8, 9);
        for (DetailAST curDetailAST : detailASTList) {
            this._checkGetHeadersMethodCall(curDetailAST);
        }
    }

    private void _checkGetHeadersMethodCall(DetailAST detailAST) {
        List<DetailAST> methodCallDetailASTList = DetailASTUtil.getMethodCalls(detailAST, "getHeaders");
        for (DetailAST methodCallDetailAST : methodCallDetailASTList) {
            String variableName;
            String variableTypeName;
            DetailAST elistDetailAST = methodCallDetailAST.findFirstToken(34);
            List<DetailAST> exprDetailASTList = DetailASTUtil.getAllChildTokens(elistDetailAST, false, 28);
            if (!exprDetailASTList.isEmpty() || !(variableTypeName = DetailASTUtil.getVariableTypeName(methodCallDetailAST, variableName = DetailASTUtil.getVariableName(methodCallDetailAST), false)).equals("Bundle")) continue;
            this.log(methodCallDetailAST, _MSG_USE_BUNDLE_GET_HEADERS, new Object[0]);
        }
    }
}

