/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.util;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.SourceFormatterArgs;
import com.liferay.source.formatter.util.CheckType;
import com.liferay.source.formatter.util.DebugUtil;
import com.liferay.source.formatter.util.SourceFormatterUtil;
import com.puppycrawl.tools.checkstyle.ConfigurationLoader;
import com.puppycrawl.tools.checkstyle.DefaultConfiguration;
import com.puppycrawl.tools.checkstyle.PropertiesExpander;
import com.puppycrawl.tools.checkstyle.PropertyResolver;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.xml.sax.InputSource;

public class CheckstyleUtil {
    public static final int BATCH_SIZE = 1000;

    public static Map<String, String> getAttributesMap(String checkName, Configuration configuration) throws CheckstyleException {
        if (Validator.isNull(checkName) || configuration == null) {
            return Collections.emptyMap();
        }
        Configuration[] checkConfigurations = CheckstyleUtil._getCheckConfigurations(configuration);
        if (checkConfigurations == null) {
            return Collections.emptyMap();
        }
        for (Configuration checkConfiguration : checkConfigurations) {
            String simpleName;
            if (!(checkConfiguration instanceof DefaultConfiguration) || !Objects.equals(simpleName = SourceFormatterUtil.getSimpleName(checkConfiguration.getName()), checkName)) continue;
            DefaultConfiguration defaultConfiguration = (DefaultConfiguration)checkConfiguration;
            String[] attributeNames = defaultConfiguration.getAttributeNames();
            HashMap<String, String> attributesMap = new HashMap<String, String>();
            for (String attributeName : attributeNames) {
                String attributeValue = defaultConfiguration.getAttribute(attributeName);
                attributesMap.put(attributeName, attributeValue);
            }
            return attributesMap;
        }
        return Collections.emptyMap();
    }

    public static String getAttributeValue(String checkName, String attributeName, Configuration configuration) throws CheckstyleException {
        Map<String, String> attributesMap = CheckstyleUtil.getAttributesMap(checkName, configuration);
        return GetterUtil.getString(attributesMap.get(attributeName));
    }

    public static List<String> getCheckNames(Configuration configuration) {
        ArrayList<String> checkNames = new ArrayList<String>();
        String name = configuration.getName();
        if (name.startsWith("com.liferay.")) {
            int pos = name.lastIndexOf(46);
            checkNames.add(name.substring(pos + 1));
        }
        for (Configuration childConfiguration : configuration.getChildren()) {
            checkNames.addAll(CheckstyleUtil.getCheckNames(childConfiguration));
        }
        return checkNames;
    }

    public static Configuration getConfiguration(String configurationFileName, Map<String, Properties> propertiesMap, SourceFormatterArgs sourceFormatterArgs) throws CheckstyleException {
        ClassLoader classLoader = CheckstyleUtil.class.getClassLoader();
        Configuration configuration = ConfigurationLoader.loadConfiguration((InputSource)new InputSource(classLoader.getResourceAsStream(configurationFileName)), (PropertyResolver)new PropertiesExpander(System.getProperties()), (ConfigurationLoader.IgnoredModulesOptions)ConfigurationLoader.IgnoredModulesOptions.EXECUTE);
        String checkName = sourceFormatterArgs.getCheckName();
        if (checkName != null) {
            configuration = CheckstyleUtil._filterCheck(configuration, checkName);
        }
        configuration = CheckstyleUtil._addAttribute(configuration, "baseDirName", sourceFormatterArgs.getBaseDirName(), "com.liferay.source.formatter.checkstyle.checks.ChainingCheck");
        configuration = CheckstyleUtil._addAttribute(configuration, "maxLineLength", String.valueOf(sourceFormatterArgs.getMaxLineLength()), "com.liferay.source.formatter.checkstyle.checks.AppendCheck", "com.liferay.source.formatter.checkstyle.checks.ConcatCheck", "com.liferay.source.formatter.checkstyle.checks.PlusStatementCheck");
        configuration = CheckstyleUtil._addAttribute(configuration, "runOutsidePortalExcludes", SourceFormatterUtil.getPropertyValue("run.outside.portal.excludes", propertiesMap), "com.liferay.source.formatter.checkstyle.checks.ParsePrimitiveTypeCheck");
        configuration = CheckstyleUtil._addAttribute(configuration, "showDebugInformation", String.valueOf(sourceFormatterArgs.isShowDebugInformation()), "com.liferay.*");
        configuration = CheckstyleUtil._addPropertiesAttributes(configuration, propertiesMap);
        if (sourceFormatterArgs.isShowDebugInformation()) {
            DebugUtil.addCheckNames(CheckType.CHECKSTYLE, CheckstyleUtil.getCheckNames(configuration));
        }
        return configuration;
    }

    private static Configuration _addAttribute(Configuration configuration, String key, String value, String ... regexChecks) {
        Configuration[] checkConfigurations = CheckstyleUtil._getCheckConfigurations(configuration);
        if (checkConfigurations == null) {
            return configuration;
        }
        for (Configuration checkConfiguration : checkConfigurations) {
            if (!(checkConfiguration instanceof DefaultConfiguration)) continue;
            String name = checkConfiguration.getName();
            for (String regexCheck : regexChecks) {
                if (!name.matches(regexCheck)) continue;
                DefaultConfiguration defaultChildConfiguration = (DefaultConfiguration)checkConfiguration;
                defaultChildConfiguration.addAttribute(key, value);
            }
        }
        return configuration;
    }

    private static Configuration _addPropertiesAttributes(Configuration configuration, Map<String, Properties> propertiesMap) throws CheckstyleException {
        Configuration[] checkConfigurations = CheckstyleUtil._getCheckConfigurations(configuration);
        if (checkConfigurations == null) {
            return configuration;
        }
        for (Configuration checkConfiguration : checkConfigurations) {
            if (!(checkConfiguration instanceof DefaultConfiguration)) continue;
            String checkName = SourceFormatterUtil.getSimpleName(checkConfiguration.getName());
            List<String> attributeNames = SourceFormatterUtil.getAttributeNames(CheckType.CHECKSTYLE, checkName, propertiesMap);
            for (String attributeName : attributeNames) {
                String value = SourceFormatterUtil.getPropertyValue(attributeName, CheckType.CHECKSTYLE, checkName, propertiesMap);
                if (Validator.isNull(value)) continue;
                DefaultConfiguration defaultChildConfiguration = (DefaultConfiguration)checkConfiguration;
                if (Validator.isBoolean(value) || Validator.isNumber(value)) {
                    configuration = CheckstyleUtil._overrideAttributeValue(configuration, defaultChildConfiguration, attributeName, value);
                    continue;
                }
                defaultChildConfiguration.addAttribute(attributeName, value);
            }
        }
        return configuration;
    }

    private static Configuration _filterCheck(Configuration configuration, String checkName) {
        DefaultConfiguration treeWalkerConfiguration = CheckstyleUtil._getChildConfiguration(configuration, "TreeWalker");
        Configuration[] checkConfigurations = treeWalkerConfiguration.getChildren();
        if (checkConfigurations == null) {
            return configuration;
        }
        for (Configuration checkConfiguration : checkConfigurations) {
            if (!(checkConfiguration instanceof DefaultConfiguration) || checkName.equals(SourceFormatterUtil.getSimpleName(checkConfiguration.getName()))) continue;
            DefaultConfiguration defaultChildConfiguration = (DefaultConfiguration)checkConfiguration;
            treeWalkerConfiguration.removeChild((Configuration)defaultChildConfiguration);
        }
        return configuration;
    }

    private static Configuration[] _getCheckConfigurations(Configuration configuration) {
        DefaultConfiguration treeWalkerConfiguration = CheckstyleUtil._getChildConfiguration(configuration, "TreeWalker");
        if (treeWalkerConfiguration == null) {
            return null;
        }
        return treeWalkerConfiguration.getChildren();
    }

    private static DefaultConfiguration _getChildConfiguration(Configuration configuration, String name) {
        if (!(configuration instanceof DefaultConfiguration)) {
            return null;
        }
        DefaultConfiguration defaultConfiguration = (DefaultConfiguration)configuration;
        for (Configuration childConfiguration : defaultConfiguration.getChildren()) {
            String configurationName = childConfiguration.getName();
            if (!configurationName.equals(name) || !(childConfiguration instanceof DefaultConfiguration)) continue;
            return (DefaultConfiguration)childConfiguration;
        }
        return null;
    }

    private static Configuration _overrideAttributeValue(Configuration configuration, DefaultConfiguration defaultChildConfiguration, String attributeName, String value) throws CheckstyleException {
        Object[] attributeNames;
        DefaultConfiguration treeWalkerConfiguration = CheckstyleUtil._getChildConfiguration(configuration, "TreeWalker");
        DefaultConfiguration copyConfiguration = new DefaultConfiguration(defaultChildConfiguration.getName());
        Map messages = defaultChildConfiguration.getMessages();
        for (Map.Entry entry : messages.entrySet()) {
            copyConfiguration.addMessage((String)entry.getKey(), (String)entry.getValue());
        }
        for (String string : attributeNames = defaultChildConfiguration.getAttributeNames()) {
            if (string.equals(attributeName)) {
                copyConfiguration.addAttribute(string, value);
                continue;
            }
            copyConfiguration.addAttribute(string, defaultChildConfiguration.getAttribute(string));
        }
        if (!ArrayUtil.contains(attributeNames, attributeName)) {
            copyConfiguration.addAttribute(attributeName, value);
        }
        treeWalkerConfiguration.removeChild((Configuration)defaultChildConfiguration);
        treeWalkerConfiguration.addChild((Configuration)copyConfiguration);
        return configuration;
    }
}

