/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.TagAttributesCheck;

public class FTLTagAttributesCheck
extends TagAttributesCheck {
    @Override
    protected TagAttributesCheck.Tag doFormatLineBreaks(TagAttributesCheck.Tag tag, String absolutePath) {
        return tag;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        content = this.formatIncorrectLineBreak(fileName, content);
        content = this._formatTagAttributes(absolutePath, content);
        return content;
    }

    private String _formatTagAttributes(String absolutePath, String content) throws Exception {
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                String trimmedLine = StringUtil.trimLeading(line);
                if (trimmedLine.startsWith("<") && trimmedLine.endsWith(">") && !trimmedLine.startsWith("<#")) {
                    line = this.formatTagAttributes(absolutePath, line, false, false);
                }
                sb.append(line);
                sb.append("\n");
            }
        }
        content = sb.toString();
        if (content.endsWith("\n")) {
            content = content.substring(0, content.length() - 1);
        }
        return content;
    }
}

