/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaDiamondOperatorCheck
extends BaseFileCheck {
    private static final Pattern _diamondOperatorPattern = Pattern.compile("(return|=)\n?(\t+| )new ([A-Za-z]+)(\\s*)<([^>][^;]*?)>\\(\n*\t*.*?\\);\n", 32);

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        return this._applyDiamondOperator(content);
    }

    private String _applyDiamondOperator(String content) {
        Matcher matcher = _diamondOperatorPattern.matcher(content);
        while (matcher.find()) {
            String match = matcher.group();
            if (match.contains("{\n")) continue;
            String className = matcher.group(3);
            String parameterType = matcher.group(5);
            if (!(!className.equals("AutoResetThreadLocal") && !className.equals("InitialThreadLocal") || !parameterType.startsWith("Map<") && !parameterType.startsWith("Set<"))) continue;
            String whitespace = matcher.group(4);
            String replacement = StringUtil.replaceFirst(match, StringBundler.concat(whitespace, "<", parameterType, ">"), "<>");
            content = StringUtil.replace(content, match, replacement);
        }
        return content;
    }
}

