/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.source.formatter.BNDSettings;
import com.liferay.source.formatter.checks.BaseJavaTermCheck;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaTerm;
import java.io.IOException;
import java.util.List;

public class JavaInternalPackageCheck
extends BaseJavaTermCheck {
    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) throws IOException {
        if (!absolutePath.contains("-web/src/") || absolutePath.contains("/test/") || absolutePath.contains("/testIntegration/")) {
            return javaTerm.getContent();
        }
        JavaClass javaClass = (JavaClass)javaTerm;
        if (javaClass.hasAnnotation("Deprecated")) {
            return javaClass.getContent();
        }
        String packageName = javaClass.getPackageName();
        if (packageName == null || packageName.contains(".internal.") || packageName.endsWith(".internal")) {
            return javaClass.getContent();
        }
        BNDSettings bndSettings = this.getBNDSettings(fileName);
        if (bndSettings == null) {
            return javaClass.getContent();
        }
        List<String> exportPackageNames = bndSettings.getExportPackageNames();
        if (!exportPackageNames.contains(packageName)) {
            this.addMessage(fileName, "Classes that are not exported should be in 'internal' package");
        }
        return javaClass.getContent();
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_CLASS};
    }
}

