/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.source.formatter.checks.BaseJavaTermCheck;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaTerm;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaTestMethodAnnotationsCheck
extends BaseJavaTermCheck {
    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) {
        if (!fileName.endsWith("Test.java")) {
            return javaTerm.getContent();
        }
        String accessModifier = javaTerm.getAccessModifier();
        if (!accessModifier.equals("public")) {
            return javaTerm.getContent();
        }
        JavaClass parentJavaClass = javaTerm.getParentJavaClass();
        if (parentJavaClass.getParentJavaClass() != null) {
            return javaTerm.getContent();
        }
        this._checkAnnotationForMethod(fileName, javaTerm, "After", "\\btearDown(?!Class)", false);
        this._checkAnnotationForMethod(fileName, javaTerm, "AfterClass", "\\btearDownClass", true);
        this._checkAnnotationForMethod(fileName, javaTerm, "Before", "\\bsetUp(?!Class)", false);
        this._checkAnnotationForMethod(fileName, javaTerm, "BeforeClass", "\\bsetUpClass", true);
        this._checkAnnotationForMethod(fileName, javaTerm, "Test", "^.*test", false);
        return javaTerm.getContent();
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_METHOD};
    }

    private void _checkAnnotationForMethod(String fileName, JavaTerm javaTerm, String annotation, String requiredMethodNameRegex, boolean staticRequired) {
        String methodName = javaTerm.getName();
        Pattern pattern = Pattern.compile(requiredMethodNameRegex);
        Matcher matcher = pattern.matcher(methodName);
        if (javaTerm.hasAnnotation(annotation)) {
            if (!matcher.find()) {
                this.addMessage(fileName, "Incorrect method name '" + methodName + "'", "test_method_naming.markdown");
            } else if (javaTerm.isStatic() != staticRequired) {
                this.addMessage(fileName, "Incorrect method type for '" + methodName + "'", "test_method_naming.markdown");
            }
        } else if (matcher.find() && !javaTerm.hasAnnotation("Override")) {
            this.addMessage(fileName, StringBundler.concat("Annotation @", annotation, " required for '", methodName, "'"), "test_method_naming.markdown");
        }
    }
}

