/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.NaturalOrderStringComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.JavaSourceUtil;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MethodCallsOrderCheck
extends BaseFileCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        return this._sortMethodCalls(content);
    }

    private boolean _isAllowedVariableType(String content, String variableName, String[] variableTypeRegexStrings) {
        if (variableTypeRegexStrings.length == 0) {
            return true;
        }
        for (String variableTypeRegex : variableTypeRegexStrings) {
            if (variableName.matches(variableTypeRegex)) {
                return true;
            }
            StringBundler sb = new StringBundler(5);
            sb.append("\\W");
            sb.append(variableTypeRegex);
            sb.append("\\s+");
            sb.append(variableName);
            sb.append("\\W");
            Pattern pattern = Pattern.compile(sb.toString());
            Matcher matcher = pattern.matcher(content);
            if (matcher.find()) {
                return true;
            }
            sb = new StringBundler(4);
            sb.append("\\W");
            sb.append(variableName);
            sb.append(" =\\s+new ");
            sb.append(variableTypeRegex);
            pattern = Pattern.compile(sb.toString());
            matcher = pattern.matcher(content);
            if (!matcher.find()) continue;
            return true;
        }
        return false;
    }

    private String _sortChainedMethodCall(String content, String methodName, int expectedParameterCount, String ... variableTypeRegexStrings) {
        if (!content.contains("." + methodName + "(")) {
            return content;
        }
        Pattern pattern = Pattern.compile("\t(\\w+)\\." + methodName + "\\(");
        Matcher matcher = pattern.matcher(content);
        PutOrSetParameterNameComparator putOrSetParameterNameComparator = new PutOrSetParameterNameComparator();
        block0: while (matcher.find()) {
            if (!this._isAllowedVariableType(content, matcher.group(1), variableTypeRegexStrings)) continue;
            String previousParameters = null;
            String previousPutOrSetParameterName = null;
            int x = matcher.end() - 1;
            while (true) {
                int compare;
                String parameters = null;
                int y = x;
                do {
                    if ((y = content.indexOf(")", y + 1)) != -1) continue;
                    return content;
                } while (this.getLevel(content.substring(x, y + 1)) != 0);
                parameters = content.substring(x + 1, y);
                List<String> parametersList = JavaSourceUtil.splitParameters(parameters);
                if (parametersList.size() != expectedParameterCount) continue block0;
                String putOrSetParameterName = parametersList.get(0);
                if (previousPutOrSetParameterName != null && (compare = putOrSetParameterNameComparator.compare(previousPutOrSetParameterName, putOrSetParameterName)) > 0) {
                    String codeBlock = content.substring(matcher.start(), y + 1);
                    String newCodeBlock = StringUtil.replaceFirst(codeBlock, previousParameters, parameters);
                    newCodeBlock = StringUtil.replaceLast(newCodeBlock, parameters, previousParameters);
                    return StringUtil.replaceFirst(content, codeBlock, newCodeBlock, matcher.start());
                }
                String s = StringUtil.trim(content.substring(y + 1));
                if (!s.startsWith("." + methodName + "(")) continue block0;
                previousParameters = parameters;
                previousPutOrSetParameterName = putOrSetParameterName;
                x = content.indexOf("(", y + 1);
            }
        }
        return content;
    }

    private String _sortMethodCall(String content, String methodName, String ... variableTypeRegexStrings) {
        if (!content.contains("." + methodName + "(")) {
            return content;
        }
        Pattern codeBlockPattern = Pattern.compile("(\t+(\\w*)\\." + methodName + "\\(\\s*\".*?\\);\n)+", 32);
        Matcher codeBlockMatcher = codeBlockPattern.matcher(content);
        PutOrSetParameterNameComparator putOrSetParameterNameComparator = new PutOrSetParameterNameComparator();
        while (codeBlockMatcher.find()) {
            if (!this._isAllowedVariableType(content, codeBlockMatcher.group(2), variableTypeRegexStrings)) continue;
            String codeBlock = codeBlockMatcher.group();
            Pattern singleLineMethodCallPattern = Pattern.compile("\t*\\w*\\." + methodName + "\\((.*?)\\);\n", 32);
            Matcher singleLineMatcher = singleLineMethodCallPattern.matcher(codeBlock);
            String previousParameters = null;
            String previousPutOrSetParameterName = null;
            while (singleLineMatcher.find()) {
                int compare;
                String parameters = singleLineMatcher.group(1);
                List<String> parametersList = JavaSourceUtil.splitParameters(parameters);
                String putOrSetParameterName = parametersList.get(0);
                if (previousPutOrSetParameterName != null && (compare = putOrSetParameterNameComparator.compare(previousPutOrSetParameterName, putOrSetParameterName)) > 0) {
                    String newCodeBlock = StringUtil.replaceFirst(codeBlock, previousParameters, parameters);
                    newCodeBlock = StringUtil.replaceLast(newCodeBlock, parameters, previousParameters);
                    return StringUtil.replace(content, codeBlock, newCodeBlock);
                }
                previousParameters = parameters;
                previousPutOrSetParameterName = putOrSetParameterName;
            }
        }
        return content;
    }

    private String _sortMethodCalls(String content) {
        content = this._sortChainedMethodCall(content, "put", 2, "JSONObject", "JSONUtil");
        content = this._sortMethodCall(content, "add", "ConcurrentSkipListSet(<.*>|\\(\\))", "HashSet(<.*>|\\(\\))", "TreeSet(<.*>|\\(\\))");
        content = this._sortMethodCall(content, "put", "ConcurrentHashMap(<.*>|\\(\\))", "HashMap(<.*>|\\(\\))", "JSONObject", "SortedMap(<.*>|\\(\\))", "TreeMap(<.*>|\\(\\))");
        content = this._sortMethodCall(content, "setAttribute", new String[0]);
        return content;
    }

    private class PutOrSetParameterNameComparator
    extends NaturalOrderStringComparator {
        private final Pattern _multipleLineParameterNamePattern = Pattern.compile("\" \\+\n\t+\"");

        private PutOrSetParameterNameComparator() {
        }

        @Override
        public int compare(String putOrSetParameterName1, String putOrSetParameterName2) {
            String strippedParameterName1 = MethodCallsOrderCheck.this.stripQuotes(putOrSetParameterName1);
            String strippedParameterName2 = MethodCallsOrderCheck.this.stripQuotes(putOrSetParameterName2);
            if (strippedParameterName1.contains("(") || strippedParameterName2.contains("(")) {
                return 0;
            }
            Matcher matcher = this._multipleLineParameterNamePattern.matcher(putOrSetParameterName1);
            if (matcher.find()) {
                putOrSetParameterName1 = matcher.replaceAll("");
            }
            if ((matcher = this._multipleLineParameterNamePattern.matcher(putOrSetParameterName2)).find()) {
                putOrSetParameterName2 = matcher.replaceAll("");
            }
            if (putOrSetParameterName1.matches("\".*\"") && putOrSetParameterName2.matches("\".*\"")) {
                String strippedQuotes1 = putOrSetParameterName1.substring(1, putOrSetParameterName1.length() - 1);
                String strippedQuotes2 = putOrSetParameterName2.substring(1, putOrSetParameterName2.length() - 1);
                return super.compare(strippedQuotes1, strippedQuotes2);
            }
            int value = super.compare(putOrSetParameterName1, putOrSetParameterName2);
            if (putOrSetParameterName1.startsWith("\"") ^ putOrSetParameterName2.startsWith("\"")) {
                return -value;
            }
            return value;
        }
    }
}

