/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.NaturalOrderStringComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;

public class PropertiesSourceFormatterFileCheck
extends BaseFileCheck {
    private static final char[][] _REVERSE_ORDER_CHARACTERS = new char[][]{{':', '.'}, {'-', '/'}};
    private Boolean _hasPrivateAppsDir;

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        if (fileName.endsWith("/source-formatter.properties")) {
            return this._formatSourceFormatterProperties(fileName, content);
        }
        return content;
    }

    private String _formatSourceFormatterProperties(String fileName, String content) throws IOException {
        int level = 3;
        if (this.isPortalSource()) {
            level = 7;
        }
        Properties properties = new Properties();
        properties.load(new StringReader(content));
        Enumeration<?> enu = properties.propertyNames();
        while (enu.hasMoreElements()) {
            String key = (String)enu.nextElement();
            String value = properties.getProperty(key);
            if (Validator.isNull(value)) continue;
            List<String> propertyValues = ListUtil.fromString(value, ",");
            if (propertyValues.size() > 1) {
                content = this._sortPropertyValues(content, key, propertyValues);
            }
            if (!key.endsWith("excludes")) continue;
            for (String propertyFileName : propertyValues) {
                File file;
                if (propertyFileName.contains("*") || propertyFileName.endsWith("-ext.properties") || this.isPortalSource() && !this._hasPrivateAppsDir() && this.isModulesApp(propertyFileName, true)) continue;
                int pos = propertyFileName.indexOf(64);
                if (pos != -1) {
                    propertyFileName = propertyFileName.substring(0, pos);
                }
                if ((file = this.getFile(propertyFileName, level)) != null) continue;
                this.addMessage(fileName, "Property value '" + propertyFileName + "' points to file that does not exist");
            }
        }
        return content;
    }

    private synchronized boolean _hasPrivateAppsDir() {
        if (this._hasPrivateAppsDir != null) {
            return this._hasPrivateAppsDir;
        }
        this._hasPrivateAppsDir = false;
        if (this.isPortalSource()) {
            return this._hasPrivateAppsDir;
        }
        File privateAppsDir = this.getFile("modules/private/apps", 7);
        if (privateAppsDir != null) {
            this._hasPrivateAppsDir = true;
        }
        return this._hasPrivateAppsDir;
    }

    private String _sortPropertyValues(String content, String propertyKey, List<String> propertyValues) {
        PropertyValueComparator comparator = new PropertyValueComparator();
        for (int i = 0; i < propertyValues.size() - 1; ++i) {
            String nextPropertyValue;
            String propertyValue = propertyValues.get(i);
            if (comparator.compare(propertyValue, nextPropertyValue = propertyValues.get(i + 1)) <= 0) continue;
            return this._swapValues(content, propertyKey, propertyValue, nextPropertyValue);
        }
        return content;
    }

    private String _swapValues(String content, int x, String s1, String s2) {
        char c;
        do {
            if ((x = content.indexOf(s1, x + 1)) != -1) continue;
            return content;
        } while (!Character.isWhitespace(c = content.charAt(x - 1)) && c != '=' && c != ',' || x + s1.length() < content.length() && !Character.isWhitespace(c = content.charAt(x + s1.length())) && c != ',');
        return StringUtil.replaceFirst(content, s1, s2, x);
    }

    private String _swapValues(String content, String propertyKey, String propertyValue, String nextPropertyValue) {
        int x = -1;
        do {
            if ((x = content.indexOf(propertyKey + "=")) != -1) continue;
            return content;
        } while (x != 0 && !Character.isWhitespace(content.charAt(x - 1)));
        content = this._swapValues(content, x, nextPropertyValue, propertyValue);
        content = this._swapValues(content, x, propertyValue, nextPropertyValue);
        return content;
    }

    private class PropertyValueComparator
    extends NaturalOrderStringComparator {
        private PropertyValueComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            int value = super.compare(s1, s2);
            if (s1.startsWith(s2) || s2.startsWith(s1)) {
                return value;
            }
            int x = StringUtil.startsWithWeight(s1, s2);
            char c1 = s1.charAt(x);
            char c2 = s2.charAt(x);
            for (char[] array : _REVERSE_ORDER_CHARACTERS) {
                if (!ArrayUtil.contains(array, c1) || !ArrayUtil.contains(array, c2)) continue;
                return -value;
            }
            if (x > 0 && s1.charAt(x - 1) == '.') {
                if (Character.isUpperCase(c1) && Character.isLowerCase(c2)) {
                    return -1;
                }
                if (Character.isLowerCase(c1) && Character.isUpperCase(c2)) {
                    return 1;
                }
            }
            return value;
        }
    }
}

