/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringMethodsCheck
extends BaseFileCheck {
    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (this.isExcludedPath("run.outside.portal.excludes", absolutePath)) {
            return content;
        }
        this._checkInefficientStringMethods(fileName, content, "\\.toLowerCase\\(\\)", "toLowerCase");
        this._checkInefficientStringMethods(fileName, content, "\\.toUpperCase\\(\\)", "toUpperCase");
        this._checkInefficientStringMethods(fileName, content, "(?<!StringUtil)\\.equalsIgnoreCase\\(", "equalsIgnoreCase");
        this._checkInefficientStringMethods(fileName, content, "\\WString\\.join\\(", "merge");
        return content;
    }

    protected boolean isJavaSource(String content, int pos) {
        return true;
    }

    private void _checkInefficientStringMethods(String fileName, String content, String regex, String methodName) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            if (!this.isJavaSource(content, matcher.start())) continue;
            this.addMessage(fileName, "Use StringUtil." + methodName, "string_methods.markdown", this.getLineNumber(content, matcher.start()));
        }
    }
}

