/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.SourceUtil;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class XMLServiceEntityNameCheck
extends BaseFileCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws DocumentException {
        if (!fileName.endsWith("/service.xml")) {
            return content;
        }
        Document document = SourceUtil.readXML(content);
        Element rootElement = document.getRootElement();
        String packagePathName = rootElement.attributeValue("package-path");
        if (!packagePathName.startsWith("com.liferay.")) {
            return content;
        }
        String trimmedPackage = StringUtil.removeChar(packagePathName, '.');
        for (Element entityElement : rootElement.elements("entity")) {
            String entityName = entityElement.attributeValue("name");
            if (!trimmedPackage.endsWith(StringUtil.lowerCase(entityName))) continue;
            this.addMessage(fileName, StringBundler.concat("Do not use entity '", entityName, "' when package is '", packagePathName, "'"), "entity_naming.markdown");
        }
        return content;
    }
}

