/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import java.util.List;

public class FactoryCheck
extends BaseCheck {
    private static final String _ENFORCE_FACTORY_CLASS_NAMES_KEY = "enforceFactoryClassNames";
    private static final String _MSG_USE_FACTORY = "factory.use";

    public int[] getDefaultTokens() {
        return new int[]{136};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        for (String enforceFactoryClassNames : this.getAttributeValues(_ENFORCE_FACTORY_CLASS_NAMES_KEY)) {
            this._checkEnforceFactory(detailAST, StringUtil.split(enforceFactoryClassNames, ':'));
        }
    }

    private void _checkEnforceFactory(DetailAST detailAST, String ... classNames) {
        List<String> importNames;
        if (classNames.length != 2) {
            return;
        }
        DetailAST firstChildDetailAST = detailAST.getFirstChild();
        if (firstChildDetailAST == null) {
            return;
        }
        String className = classNames[0];
        if (firstChildDetailAST.getType() == 59) {
            FullIdent fullIdent = FullIdent.createFullIdent((DetailAST)firstChildDetailAST);
            if (className.equals(fullIdent.getText())) {
                this.log(detailAST, _MSG_USE_FACTORY, new Object[]{classNames[1], className});
            }
        } else if (firstChildDetailAST.getType() == 58 && className.endsWith("." + firstChildDetailAST.getText()) && (importNames = DetailASTUtil.getImportNames(detailAST)).contains(className)) {
            this.log(detailAST, _MSG_USE_FACTORY, new Object[]{classNames[1], className});
        }
    }
}

